/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.data.filter;

import info.msxlaunchers.openmsx.launcher.data.filter.Filter;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterDescriptor;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterType;
import info.msxlaunchers.openmsx.launcher.data.filter.Value1Field;
import info.msxlaunchers.openmsx.launcher.data.game.Game;
import info.msxlaunchers.openmsx.launcher.data.game.constants.MSXGeneration;
import info.msxlaunchers.openmsx.launcher.data.repository.RepositoryGame;
import java.util.Objects;

@FilterDescriptor(type=FilterType.GENERATION)
final class GenerationFilter
implements Filter {
    @Value1Field
    private final MSXGeneration generation;

    GenerationFilter(MSXGeneration generation) {
        this.generation = Objects.requireNonNull(generation);
    }

    public int hashCode() {
        return this.generation.hashCode();
    }

    public boolean equals(Object obj) {
        boolean isSame = obj == null || !(obj instanceof GenerationFilter) ? false : this.generation.equals(((GenerationFilter)obj).generation);
        return isSame;
    }

    @Override
    public boolean isFiltered(Game game, RepositoryGame repositoryGame) {
        Objects.requireNonNull(game);
        boolean filtered = false;
        switch (this.generation) {
            case MSX: {
                filtered = !game.isMSX();
                break;
            }
            case MSX2: {
                filtered = !game.isMSX2();
                break;
            }
            case MSX2Plus: {
                filtered = !game.isMSX2Plus();
                break;
            }
            case TURBO_R: {
                filtered = !game.isTurboR();
                break;
            }
            default: {
                throw new RuntimeException("Update filter if MSXGeneration contains an extra generation");
            }
        }
        return filtered;
    }
}

