/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.data.game;

import java.util.Objects;

public final class DatabaseItem {
    private final String gameName;
    private final String database;

    public DatabaseItem(String gameName, String database) {
        this.gameName = this.validateNonNull(gameName);
        this.database = this.validateNonNull(database);
    }

    public String getGameName() {
        return this.gameName;
    }

    public String getDatabase() {
        return this.database;
    }

    public int hashCode() {
        return Objects.hash(this.gameName, this.database);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DatabaseItem other = (DatabaseItem)obj;
        return this.gameName.equals(other.gameName) && this.database.equals(other.database);
    }

    public static DatabaseItem getDatabaseItem(String databaseItemString) {
        DatabaseItem databaseItem;
        if (databaseItemString == null) {
            databaseItem = new DatabaseItem("", "");
        } else {
            int lastClosingBracketIndex = databaseItemString.lastIndexOf(93);
            if (lastClosingBracketIndex > -1) {
                int lastOpeningBracketIndex = databaseItemString.lastIndexOf(91, lastClosingBracketIndex);
                if (lastOpeningBracketIndex > -1 && lastOpeningBracketIndex < lastClosingBracketIndex) {
                    String gameName = databaseItemString.substring(0, lastOpeningBracketIndex).trim();
                    String database = databaseItemString.substring(lastOpeningBracketIndex + 1, lastClosingBracketIndex);
                    databaseItem = new DatabaseItem(gameName, database);
                } else {
                    databaseItem = new DatabaseItem("", "");
                }
            } else {
                databaseItem = new DatabaseItem("", "");
            }
        }
        return databaseItem;
    }

    public String toString() {
        return this.gameName + " [" + this.database + "]";
    }

    private <T> T validateNonNull(T object) {
        if (object == null) {
            throw new IllegalArgumentException("Object is null");
        }
        return object;
    }
}

