/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.data.settings;

import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import java.util.Objects;

public final class Settings {
    private final String openMSXFullPath;
    private final String openMSXMachinesFullPath;
    private final String screenshotsFullPath;
    private final String defaultDatabase;
    private final Language language;
    private final boolean showUpdateAllDatabases;
    private final boolean enableFeedService;

    public Settings(String openMSXFullPath, String openMSXMachinesFullPath, String screenshotsFullPath, String defaultDatabase, Language language, boolean showUpdateAllDatabases, boolean enableFeedService) {
        this.openMSXFullPath = openMSXFullPath;
        this.openMSXMachinesFullPath = openMSXMachinesFullPath;
        this.screenshotsFullPath = screenshotsFullPath;
        this.defaultDatabase = defaultDatabase;
        this.language = language;
        this.showUpdateAllDatabases = showUpdateAllDatabases;
        this.enableFeedService = enableFeedService;
    }

    public int hashCode() {
        return Objects.hash(this.defaultDatabase, this.language, this.openMSXFullPath, this.openMSXMachinesFullPath, this.screenshotsFullPath, this.showUpdateAllDatabases, this.enableFeedService);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Settings) {
            Settings other = (Settings)obj;
            return Objects.equals(this.defaultDatabase, other.defaultDatabase) && Objects.equals(this.language, other.language) && Objects.equals(this.openMSXFullPath, other.openMSXFullPath) && Objects.equals(this.openMSXMachinesFullPath, other.openMSXMachinesFullPath) && Objects.equals(this.screenshotsFullPath, other.screenshotsFullPath) && Objects.equals(this.showUpdateAllDatabases, other.showUpdateAllDatabases) && Objects.equals(this.enableFeedService, other.enableFeedService);
        }
        return false;
    }

    public String getOpenMSXFullPath() {
        if (Utils.isEmpty(this.openMSXFullPath)) {
            return null;
        }
        return this.openMSXFullPath;
    }

    public String getOpenMSXMachinesFullPath() {
        if (Utils.isEmpty(this.openMSXMachinesFullPath)) {
            return null;
        }
        return this.openMSXMachinesFullPath;
    }

    public String getScreenshotsFullPath() {
        if (Utils.isEmpty(this.screenshotsFullPath)) {
            return null;
        }
        return this.screenshotsFullPath;
    }

    public String getDefaultDatabase() {
        if (Utils.isEmpty(this.defaultDatabase)) {
            return null;
        }
        return this.defaultDatabase;
    }

    public Language getLanguage() {
        return this.language;
    }

    public boolean isShowUpdateAllDatabases() {
        return this.showUpdateAllDatabases;
    }

    public boolean isEnableFeedService() {
        return this.enableFeedService;
    }
}

