/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.data.settings.constants;

import info.msxlaunchers.openmsx.common.NumericalEnum;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum Language implements NumericalEnum
{
    ENGLISH(1, "en_US"),
    ARABIC(2, "ar_KW"),
    CATALAN(3, "ca_ES"),
    CHINESE_SIMPLIFIED(4, "zh_CN"),
    CHINESE_TRADITIONAL(5, "zh_TW"),
    DUTCH(6, "nl_NL"),
    FINNISH(7, "fi_FI"),
    FRENCH(8, "fr_FR"),
    GERMAN(9, "de_DE"),
    ITALIAN(10, "it_IT"),
    JAPANESE(11, "ja_JP"),
    KOREAN(12, "ko_KR"),
    PERSIAN(13, "fa_IR"),
    PORTUGUESE(14, "pt_BR"),
    RUSSIAN(15, "ru_RU"),
    SPANISH(16, "es_ES"),
    SWEDISH(17, "sv_SE"),
    POLISH(18, "pl_PL");

    private final int value;
    private final String localeName;
    private static Map<Integer, Language> valuesMap;
    private static Map<String, Language> localesMap;

    private Language(int value, String localeName) {
        this.value = value;
        this.localeName = localeName;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public String getLocaleName() {
        return this.localeName;
    }

    public static Language fromValue(int value) {
        return valuesMap.get(value);
    }

    public static Language fromLocale(String localeName) {
        return localesMap.get(localeName);
    }

    public static boolean isLeftToRight(Language language) {
        return !Language.isRightToLeft(language);
    }

    public static boolean isRightToLeft(Language language) {
        if (language == null) {
            return false;
        }
        return language.equals(ARABIC) || language.equals(PERSIAN);
    }

    static {
        valuesMap = new HashMap<Integer, Language>();
        localesMap = new HashMap<String, Language>();
        for (Language language : Language.values()) {
            valuesMap.put(language.getValue(), language);
            localesMap.put(language.getLocaleName(), language);
        }
        valuesMap = Collections.unmodifiableMap(valuesMap);
        localesMap = Collections.unmodifiableMap(localesMap);
    }
}

