/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.extra;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import info.msxlaunchers.openmsx.common.HashUtils;
import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.openmsx.launcher.data.extra.ExtraData;
import info.msxlaunchers.openmsx.launcher.extra.ExtraDataGetter;
import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Singleton
final class ExtraDataGetterImpl
implements ExtraDataGetter {
    private final String extraDataDirectory;
    private static final String EXTRA_DATA_FILENAME = "extra-data.dat";
    private static final String COMMENT_START = "--";
    private static final char GENERATION_MSX_ID_START = '#';
    private static final char COMMA = ',';
    private static final char PIPE = '|';
    private static final String VERSION_COMMENT = "-- Version ";
    private static String cachedExtraDataFileHash = null;
    private static Map<String, ExtraData> cachedExtraDataMap = null;

    @Inject
    ExtraDataGetterImpl(@Named(value="LauncherDataDirectory") String extraDataDirectory) {
        this.extraDataDirectory = extraDataDirectory;
    }

    @Override
    public Map<String, ExtraData> getExtraData() throws IOException {
        File extraDataFile = new File(this.extraDataDirectory, EXTRA_DATA_FILENAME);
        String extraDataFileHash = HashUtils.getSHA1Code(extraDataFile);
        if (extraDataFileHash == null) {
            FileNotFoundException ioe = new FileNotFoundException();
            LauncherLogger.logException(this, ioe);
            throw ioe;
        }
        if (!extraDataFileHash.equals(cachedExtraDataFileHash)) {
            cachedExtraDataFileHash = extraDataFileHash;
            cachedExtraDataMap = this.readExtraDataFileAndGetMap(extraDataFile);
        }
        return cachedExtraDataMap;
    }

    private Map<String, ExtraData> readExtraDataFileAndGetMap(File extraDataFile) throws IOException {
        HashMap<String, ExtraData> extraDataMap = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(extraDataFile), "UTF-8"));){
            extraDataMap = new HashMap<String, ExtraData>();
            String text = null;
            boolean done = false;
            while (!done) {
                text = reader.readLine();
                if (text == null) {
                    done = true;
                    continue;
                }
                if (text.startsWith(COMMENT_START) || text.charAt(0) != '#') continue;
                int generationMSXId = Utils.getNumber(text.substring(1));
                text = reader.readLine();
                if (text == null) {
                    done = false;
                    continue;
                }
                String[] values = this.splitGenerationsSoundChipsGenres(text);
                ExtraData extraData = new ExtraData(generationMSXId, Utils.getNumber(values[0]), Utils.getNumber(values[1]), Utils.getNumber(values[2]), Utils.getNumber(values[3]), values[4]);
                text = reader.readLine();
                if (text == null) {
                    done = true;
                    continue;
                }
                this.processSha1Codes(extraDataMap, extraData, text);
            }
        }
        return Collections.unmodifiableMap(extraDataMap);
    }

    @Override
    public String getExtraDataFileVersion() throws IOException {
        String version = null;
        File file = new File(this.extraDataDirectory, EXTRA_DATA_FILENAME);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
            String text = null;
            String versionLine = null;
            boolean done = false;
            boolean startedVersionSection = false;
            while (!done) {
                text = reader.readLine();
                if (text == null) {
                    version = "0.0";
                    done = true;
                    continue;
                }
                if (text.startsWith(VERSION_COMMENT)) {
                    startedVersionSection = true;
                    versionLine = text;
                    continue;
                }
                if (!startedVersionSection) continue;
                int beginIndex = VERSION_COMMENT.length();
                int endIndex = versionLine.indexOf(32, beginIndex);
                version = endIndex > beginIndex ? versionLine.substring(beginIndex, endIndex) : "0.0";
                done = true;
            }
        }
        return version;
    }

    private String[] splitGenerationsSoundChipsGenres(String line) {
        String[] values = new String[5];
        int indexFirstComma = line.indexOf(44);
        if (indexFirstComma > -1) {
            values[0] = line.substring(0, indexFirstComma);
            int indexSecondComma = line.indexOf(44, indexFirstComma + 1);
            if (indexSecondComma > -1) {
                values[1] = line.substring(indexFirstComma + 1, indexSecondComma);
                int indexThirdComma = line.indexOf(44, indexSecondComma + 1);
                if (indexThirdComma > -1) {
                    String[] genres = this.splitGenres(line.substring(indexSecondComma + 1, indexThirdComma));
                    values[2] = genres[0];
                    values[3] = genres[1];
                    values[4] = line.substring(indexThirdComma + 1);
                } else {
                    String[] genres = this.splitGenres(line.substring(indexSecondComma + 1));
                    values[2] = genres[0];
                    values[3] = genres[1];
                }
            }
        }
        return values;
    }

    private String[] splitGenres(String text) {
        String[] genres = new String[2];
        int indexPipe = text.indexOf(124);
        if (indexPipe > -1) {
            genres[0] = text.substring(0, indexPipe);
            genres[1] = text.substring(indexPipe + 1);
        } else {
            genres[0] = text;
        }
        return genres;
    }

    private void processSha1Codes(Map<String, ExtraData> extraDataMap, ExtraData extraData, String line) {
        boolean done = false;
        int startDigit = 0;
        while (!done) {
            int indexPipe = line.indexOf(124, startDigit);
            if (indexPipe > -1) {
                extraDataMap.put(line.substring(startDigit, indexPipe), extraData);
                startDigit = indexPipe + 1;
                continue;
            }
            extraDataMap.put(line.substring(startDigit), extraData);
            done = true;
        }
    }
}

