/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.log;

import info.msxlaunchers.openmsx.common.OSUtils;
import info.msxlaunchers.openmsx.launcher.log.LogEvent;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public final class LauncherLogger {
    private static final String LOG_DIRECTORY = OSUtils.getUserDataDirectory();
    private static final String MESSAGE_LOGGER_NAME = "MessageLogger";
    private static final String EXCEPTION_LOGGER_NAME = "ExceptionLogger";
    public static final String MESSAGE_LOG_FILENAME = "message.log";
    private static final String EXCEPTION_LOG_FILENAME = "exception.log";
    private static final int MAX_LOG_SIZE = 51200;
    private static final int MAX_LOGS_NUMBER = 2;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Logger messageLogger = Logger.getLogger("MessageLogger");
    private static final Logger exceptionLogger = Logger.getLogger("ExceptionLogger");

    public static void logMessage(LogEvent event, String message) {
        LauncherLogger.logMessage((Object)((Object)event) + " " + message);
    }

    public static void logMessage(String message) {
        messageLogger.info(message);
    }

    public static void logException(Object object, Exception ex) {
        exceptionLogger.log(Level.SEVERE, object.getClass().getName() + " - " + ex.getMessage(), ex);
    }

    static {
        FileHandler messageHandler = null;
        FileHandler exceptionHandler = null;
        try {
            messageHandler = new FileHandler(new File(LOG_DIRECTORY, MESSAGE_LOG_FILENAME).toString(), 51200, 2, true);
            ((Handler)messageHandler).setEncoding("UTF-8");
            exceptionHandler = new FileHandler(new File(LOG_DIRECTORY, EXCEPTION_LOG_FILENAME).toString(), 51200, 2, true);
            ((Handler)exceptionHandler).setEncoding("UTF-8");
        }
        catch (IOException | SecurityException ex) {
            throw new RuntimeException(ex);
        }
        messageHandler.setFormatter(new MessageFormatter());
        messageLogger.addHandler(messageHandler);
        messageLogger.setUseParentHandlers(false);
        exceptionHandler.setFormatter(new SimpleFormatter());
        exceptionLogger.addHandler(exceptionHandler);
        exceptionLogger.setUseParentHandlers(false);
    }

    private static class MessageFormatter
    extends Formatter {
        private MessageFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            return new Date(record.getMillis()) + ": " + record.getMessage() + LINE_SEPARATOR;
        }
    }
}

