/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.log.analyser;

import com.google.inject.Inject;
import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.openmsx.launcher.log.LogEvent;
import info.msxlaunchers.openmsx.launcher.log.analyser.LogAnalyser;
import info.msxlaunchers.openmsx.launcher.log.analyser.LogProcessor;
import info.msxlaunchers.openmsx.launcher.log.analyser.LogReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class LogAnalyserImpl
implements LogAnalyser {
    private final LogReader logReader;
    private final Map<LogEvent, LogProcessor> logProcessors;

    @Inject
    LogAnalyserImpl(LogReader logReader, Map<LogEvent, LogProcessor> logProcessors) {
        this.logReader = logReader;
        this.logProcessors = logProcessors;
    }

    @Override
    public Map<String, List<String[]>> getProcessedData() {
        List<String> logLines = this.logReader.read();
        HashMap<String, List<String[]>> processedData = new HashMap<String, List<String[]>>();
        for (String line : logLines) {
            LogEvent logEvent = this.getLogEvent(line);
            LogProcessor logProcessor = this.logProcessors.get((Object)logEvent);
            if (logProcessor == null) continue;
            String[] lineDateAndLogMessage = this.getLineDateAndMessage(line, logEvent);
            logProcessor.processMessage(lineDateAndLogMessage[0], lineDateAndLogMessage[1]);
        }
        for (LogProcessor logProcessor : this.logProcessors.values()) {
            processedData.putAll(logProcessor.getProcessedData());
        }
        return processedData;
    }

    private LogEvent getLogEvent(String line) {
        int firstIndex;
        int secondIndex;
        LogEvent event = null;
        if (!Utils.isEmpty(line) && (secondIndex = line.indexOf(" ", firstIndex = line.indexOf(": ") + 2)) > firstIndex) {
            String eventString = line.substring(firstIndex, secondIndex);
            try {
                event = LogEvent.valueOf(eventString);
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                // empty catch block
            }
        }
        return event;
    }

    private String[] getLineDateAndMessage(String line, LogEvent logEvent) {
        String splitString = ": " + (Object)((Object)logEvent) + " ";
        int firstIndex = line.indexOf(splitString);
        int secondIndex = firstIndex + splitString.length();
        return new String[]{line.substring(0, firstIndex), line.substring(secondIndex, line.length())};
    }
}

