/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence.favorite;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import info.msxlaunchers.openmsx.launcher.data.game.DatabaseItem;
import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.favorite.DeleteFavoriteAction;
import info.msxlaunchers.openmsx.launcher.persistence.favorite.FavoritePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.favorite.FavoritePersister;
import info.msxlaunchers.openmsx.launcher.persistence.favorite.GetFavoritesAction;
import info.msxlaunchers.openmsx.launcher.persistence.favorite.SaveFavoriteAction;
import java.util.Objects;
import java.util.Set;

@Singleton
final class EmbeddedDatabaseFavoritePersister
implements FavoritePersister {
    private final String databaseFullPath;

    @Inject
    EmbeddedDatabaseFavoritePersister(@Named(value="EmbeddedDatabaseFullPath") String databaseFullPath) {
        this.databaseFullPath = databaseFullPath;
    }

    @Override
    public void addFavorite(DatabaseItem favorite) throws FavoritePersistenceException {
        Objects.requireNonNull(favorite);
        try {
            new SaveFavoriteAction(favorite).execute(this.databaseFullPath);
        }
        catch (LauncherPersistenceException lpe) {
            throw (FavoritePersistenceException)lpe.getException();
        }
    }

    @Override
    public void deleteFavorite(DatabaseItem favorite) throws FavoritePersistenceException {
        Objects.requireNonNull(favorite);
        try {
            new DeleteFavoriteAction(favorite).execute(this.databaseFullPath);
        }
        catch (LauncherPersistenceException lpe) {
            throw (FavoritePersistenceException)lpe.getException();
        }
    }

    @Override
    public Set<DatabaseItem> getFavorites() {
        try {
            return (Set)new GetFavoritesAction().execute(this.databaseFullPath).getResult();
        }
        catch (LauncherPersistenceException launcherPersistenceException) {
            return null;
        }
    }
}

