/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence.feed;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import info.msxlaunchers.openmsx.launcher.persistence.feed.FeedMessagePersister;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

final class FeedMessageFilePersister
implements FeedMessagePersister {
    private final String FEED_DIRECTORY = "feed";
    private final String PREVIOUS_TOP_MESSAGE_FILENAME = "previousTopMessage";
    private final Path persistedTopMessageFile;

    @Inject
    FeedMessageFilePersister(@Named(value="UserDataDirectory") String userDataDirectory) throws IOException {
        Path feedDirectory = Paths.get(userDataDirectory, "feed");
        if (Files.notExists(feedDirectory, new LinkOption[0])) {
            try {
                Files.createDirectory(feedDirectory, new FileAttribute[0]);
            }
            catch (IOException ioe) {
                LauncherLogger.logException(this, ioe);
                throw ioe;
            }
        }
        this.persistedTopMessageFile = Paths.get(feedDirectory.toString(), "previousTopMessage");
    }

    @Override
    public void saveMessage(String message) throws IOException {
        try {
            Files.write(this.persistedTopMessageFile, message.getBytes(), new OpenOption[0]);
        }
        catch (IOException ioe) {
            LauncherLogger.logException(this, ioe);
            throw ioe;
        }
    }

    @Override
    public String getMessage() throws IOException {
        try {
            return new String(Files.readAllBytes(this.persistedTopMessageFile));
        }
        catch (IOException ioe) {
            LauncherLogger.logException(this, ioe);
            throw ioe;
        }
    }

    @Override
    public boolean isMessagePersisted() {
        return Files.exists(this.persistedTopMessageFile, new LinkOption[0]);
    }
}

