/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence.game;

import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import info.msxlaunchers.openmsx.launcher.persistence.DefaultDatabaseResponse;
import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.TransactionalDatabaseOperation;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceExceptionIssue;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

final class CreateDatabaseAction
extends TransactionalDatabaseOperation<Boolean> {
    private static final String INSERT_DATABASE_STATEMENT = "INSERT INTO database (name) VALUES (?)";
    private final String database;

    CreateDatabaseAction(String database) {
        this.database = database;
    }

    public DefaultDatabaseResponse executeTransactionalOperation(Connection connection) throws LauncherPersistenceException {
        try (PreparedStatement statement = connection.prepareStatement(INSERT_DATABASE_STATEMENT);){
            statement.setString(1, this.database);
            statement.executeUpdate();
        }
        catch (SQLException se) {
            if (this.isDuplicateError(se)) {
                this.throwEncapsulatingException(new GamePersistenceException(GamePersistenceExceptionIssue.DATABASE_ALREADY_EXISTS, this.database));
            }
            LauncherLogger.logException(this, se);
            this.throwEncapsulatingException(new GamePersistenceException(GamePersistenceExceptionIssue.IO));
        }
        return new DefaultDatabaseResponse();
    }
}

