/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence.game;

import info.msxlaunchers.openmsx.launcher.data.game.Game;
import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import info.msxlaunchers.openmsx.launcher.persistence.DefaultDatabaseResponse;
import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.TransactionalDatabaseOperation;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceExceptionIssue;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Set;

final class DeleteGamesAction
extends TransactionalDatabaseOperation<Boolean> {
    private static final String DELETE_GAME_STATEMENT = "DELETE FROM game WHERE name=? AND IDDB=?";
    private final Set<Game> games;
    private final String database;

    DeleteGamesAction(Set<Game> games, String database) {
        this.games = games;
        this.database = database;
    }

    public DefaultDatabaseResponse executeTransactionalOperation(Connection connection) throws LauncherPersistenceException {
        long databaseId = this.getDatabaseId(connection, this.database);
        try (PreparedStatement statement = connection.prepareStatement(DELETE_GAME_STATEMENT);){
            for (Game game : this.games) {
                statement.setString(1, game.getName());
                statement.setLong(2, databaseId);
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLException se) {
            LauncherLogger.logException(this, se);
            this.throwEncapsulatingException(new GamePersistenceException(GamePersistenceExceptionIssue.IO));
        }
        return new DefaultDatabaseResponse();
    }
}

