/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence.game;

import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.TransactionalDatabaseOperation;
import info.msxlaunchers.openmsx.launcher.persistence.game.BackupDatabaseAction;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceExceptionIssue;
import info.msxlaunchers.openmsx.launcher.persistence.game.GetDatabasesAction;
import info.msxlaunchers.openmsx.launcher.persistence.game.UpdateMachineResponse;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;

final class UpdateMachineAction
extends TransactionalDatabaseOperation<Integer> {
    private static final String UPDATE_MACHINE_STATEMENT = "UPDATE game SET machine=?";
    private final String to;
    private final String from;
    private final String database;
    private final boolean backupAffectedDatabases;

    UpdateMachineAction(String to, String from, String database, boolean backupAffectedDatabases) {
        this.to = to;
        this.from = from;
        this.database = database;
        this.backupAffectedDatabases = backupAffectedDatabases;
    }

    public UpdateMachineResponse executeTransactionalOperation(Connection connection) throws LauncherPersistenceException {
        if (this.backupAffectedDatabases) {
            Set<String> databasesToBackups = this.getDatabasesToBackup(connection);
            for (String databaseToBackup : databasesToBackups) {
                new BackupDatabaseAction(databaseToBackup).executeTransactionalOperation(connection);
            }
        }
        String statementString = this.getStatementString();
        int totalUpdated = 0;
        try (PreparedStatement statement = connection.prepareStatement(statementString);){
            this.setParameters(connection, statement, statementString);
            totalUpdated = statement.executeUpdate();
        }
        catch (SQLException se) {
            this.throwEncapsulatingException(new GamePersistenceException(GamePersistenceExceptionIssue.IO));
        }
        return new UpdateMachineResponse(totalUpdated);
    }

    private Set<String> getDatabasesToBackup(Connection connection) {
        if (this.database == null) {
            return new GetDatabasesAction().executeNonTransactionalOperation(connection).getResult();
        }
        return Collections.singleton(this.database);
    }

    private String getStatementString() {
        StringBuilder builder = new StringBuilder(UPDATE_MACHINE_STATEMENT);
        if (this.from != null || this.database != null) {
            builder.append(" WHERE ");
            if (this.from != null) {
                builder.append("machine=?");
            }
            if (this.database != null) {
                if (this.from != null) {
                    builder.append(" AND ");
                }
                builder.append("IDDB=?");
            }
        }
        return builder.toString();
    }

    private void setParameters(Connection connection, PreparedStatement statement, String statementString) throws SQLException {
        int index = 1;
        statement.setString(index++, this.to);
        if (this.from != null) {
            statement.setString(index++, this.from);
        }
        if (this.database != null) {
            statement.setLong(index, this.getDatabaseId(connection, this.database));
        }
    }
}

