/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence.settings;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.openmsx.launcher.data.settings.Settings;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.persistence.settings.SettingsPersister;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.Properties;

@Singleton
final class FileSettingsPersister
implements SettingsPersister {
    private final String SETTINGS_FILENAME = "settings-oml.ini";
    private static final String OPENMSX_FULL_PATH = "openmsx-path";
    private static final String OPENMSX_MACHINES_FULL_PATH = "openmsx-machines-path";
    private static final String SCREENSHOTS_FULL_PATH = "screenshots-path";
    private static final String DEFAULT_DATABASE = "default-database";
    private static final String LANGUAGE = "language";
    private static final String SHOW_UPDATE_ALL_DATABASES = "showUpdateAllDatabases";
    private static final String ENABLE_FEED_SERVICE = "enableFeedService";
    private final File settingsFile;
    private Settings cachedSettings = null;

    @Inject
    FileSettingsPersister(@Named(value="UserDataDirectory") String settingsPath) {
        Objects.requireNonNull(settingsPath);
        this.settingsFile = new File(settingsPath, "settings-oml.ini");
    }

    @Override
    public void saveSettings(Settings settings) throws IOException {
        Objects.requireNonNull(settings);
        Properties properties = new Properties();
        String openMSXFullPath = FileSettingsPersister.getPropertyValue(settings.getOpenMSXFullPath());
        String openMSXMachinesFullPath = FileSettingsPersister.getPropertyValue(settings.getOpenMSXMachinesFullPath());
        String screenshotsFullPath = FileSettingsPersister.getPropertyValue(settings.getScreenshotsFullPath());
        String defaultDatabase = FileSettingsPersister.getPropertyValue(settings.getDefaultDatabase());
        String language = Utils.getEnumValue(settings.getLanguage());
        boolean showUpdateAllDatabases = settings.isShowUpdateAllDatabases();
        boolean enableFeedService = settings.isEnableFeedService();
        properties.put(OPENMSX_FULL_PATH, openMSXFullPath);
        properties.put(OPENMSX_MACHINES_FULL_PATH, openMSXMachinesFullPath);
        properties.put(SCREENSHOTS_FULL_PATH, screenshotsFullPath);
        properties.put(DEFAULT_DATABASE, defaultDatabase);
        properties.put(LANGUAGE, language);
        properties.put(SHOW_UPDATE_ALL_DATABASES, new Boolean(showUpdateAllDatabases).toString());
        properties.put(ENABLE_FEED_SERVICE, new Boolean(enableFeedService).toString());
        try (FileOutputStream stream = new FileOutputStream(this.settingsFile);){
            properties.store(stream, null);
            this.cachedSettings = new Settings(openMSXFullPath, openMSXMachinesFullPath, screenshotsFullPath, defaultDatabase, Language.fromValue(Utils.getNumber(language)), showUpdateAllDatabases, enableFeedService);
        }
    }

    @Override
    public Settings getSettings() throws IOException {
        Settings settings = this.cachedSettings;
        if (settings == null) {
            Properties properties = new Properties();
            try (FileInputStream stream = new FileInputStream(this.settingsFile);){
                properties.load(stream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            this.cachedSettings = settings = new Settings(properties.getProperty(OPENMSX_FULL_PATH), properties.getProperty(OPENMSX_MACHINES_FULL_PATH), properties.getProperty(SCREENSHOTS_FULL_PATH), properties.getProperty(DEFAULT_DATABASE), Language.fromValue(Utils.getNumber(properties.getProperty(LANGUAGE))), Boolean.parseBoolean(properties.getProperty(SHOW_UPDATE_ALL_DATABASES, "false")), Boolean.parseBoolean(properties.getProperty(ENABLE_FEED_SERVICE, "false")));
        }
        return settings;
    }

    private static String getPropertyValue(String propertyValue) {
        String value = propertyValue == null ? "" : propertyValue;
        return value;
    }
}

