/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.starter;

import com.google.inject.Inject;
import info.msxlaunchers.openmsx.launcher.data.game.Game;
import info.msxlaunchers.openmsx.launcher.data.settings.Settings;
import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import info.msxlaunchers.openmsx.launcher.starter.EmulatorStarter;
import info.msxlaunchers.openmsx.launcher.starter.StarterPlatformArguments;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

final class OpenMSXStarter
implements EmulatorStarter {
    private final StarterPlatformArguments platformArguments;

    @Inject
    OpenMSXStarter(StarterPlatformArguments platformArguments) {
        this.platformArguments = Objects.requireNonNull(platformArguments);
    }

    @Override
    public Process start(Settings settings, Game game) throws IOException {
        Objects.requireNonNull(settings);
        Objects.requireNonNull(game);
        List<String> arguments = this.platformArguments.getArguments(settings, game);
        LauncherLogger.logMessage(arguments.stream().collect(Collectors.joining(" ")));
        ProcessBuilder pb = new ProcessBuilder(arguments);
        return pb.start();
    }
}

