/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.presenter;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import info.msxlaunchers.openmsx.launcher.data.backup.DatabaseBackup;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistence;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceExceptionIssue;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersister;
import info.msxlaunchers.openmsx.launcher.ui.presenter.DatabaseAndBackups;
import info.msxlaunchers.openmsx.launcher.ui.presenter.DatabaseBackupsPresenterFactory;
import info.msxlaunchers.openmsx.launcher.ui.presenter.DatabaseInfo;
import info.msxlaunchers.openmsx.launcher.ui.presenter.DatabaseManagerPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherExceptionCode;
import info.msxlaunchers.openmsx.launcher.ui.presenter.MainPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.DatabaseManagerView;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

final class DatabaseManagerPresenterImpl
implements DatabaseManagerPresenter {
    private final DatabaseManagerView view;
    private final MainPresenter mainPresenter;
    private final LauncherPersistence launcherPersistence;
    private final DatabaseBackupsPresenterFactory databaseBackupsPresenterFactory;
    private final Set<String> databases;
    private final Language currentLanguage;
    private final boolean currentRightToLeft;

    @Inject
    DatabaseManagerPresenterImpl(DatabaseManagerView view, MainPresenter launcherPresenter, LauncherPersistence launcherPersistence, DatabaseBackupsPresenterFactory databaseBackupsPresenterFactory, @Assisted Set<String> databases, @Assisted Language currentLanguage, @Assisted boolean currentRightToLeft) {
        this.view = Objects.requireNonNull(view);
        this.mainPresenter = Objects.requireNonNull(launcherPresenter);
        this.launcherPersistence = Objects.requireNonNull(launcherPersistence);
        this.databaseBackupsPresenterFactory = Objects.requireNonNull(databaseBackupsPresenterFactory);
        this.databases = Objects.requireNonNull(databases);
        this.currentLanguage = Objects.requireNonNull(currentLanguage);
        this.currentRightToLeft = Objects.requireNonNull(currentRightToLeft);
    }

    @Override
    public void onRequestDatabaseManagerScreen() {
        Comparator<DatabaseAndBackups> byName = Comparator.comparing(DatabaseAndBackups::getName, String.CASE_INSENSITIVE_ORDER);
        Set databaseAndBackups = this.databases.stream().map(d -> new DatabaseAndBackups((String)d, this.getTotalGamesInDatabase((String)d), this.launcherPersistence.getGamePersister().getBackups((String)d).size())).collect(Collectors.toCollection(() -> new TreeSet(byName)));
        this.view.displayScreen(this, this.currentLanguage, this.currentRightToLeft, databaseAndBackups);
    }

    @Override
    public void onRequestDeleteDatabase(String database) throws LauncherException {
        try {
            this.launcherPersistence.getGamePersister().deleteDatabase(database);
            this.mainPresenter.onRequestDeleteDatabaseAction(database);
        }
        catch (GamePersistenceException gpe) {
            if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.DATABASE_NOT_FOUND)) {
                throw new LauncherException(LauncherExceptionCode.ERR_DATABASE_NOT_FOUND, database);
            }
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
    }

    @Override
    public String onRequestRenameDatabaseScreen(String database) {
        return this.view.displayRenameDatabaseScreen(this, database, this.currentLanguage, this.currentRightToLeft);
    }

    @Override
    public void onRequestRenameDatabaseAction(String oldDatabase, String newDatabase) throws LauncherException {
        try {
            this.launcherPersistence.getGamePersister().renameDatabase(oldDatabase, newDatabase);
            this.mainPresenter.onRequestRenameDatabaseAction(oldDatabase, newDatabase);
        }
        catch (GamePersistenceException gpe) {
            if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.DATABASE_NOT_FOUND)) {
                throw new LauncherException(LauncherExceptionCode.ERR_DATABASE_NOT_FOUND, oldDatabase);
            }
            if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.DATABASE_ALREADY_EXISTS)) {
                throw new LauncherException(LauncherExceptionCode.ERR_DATABASE_ALREADY_EXISTS, newDatabase);
            }
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
    }

    @Override
    public void onRequestDeleteAllBackups() throws LauncherException {
        for (String database : this.databases) {
            Set<DatabaseBackup> backups = this.launcherPersistence.getGamePersister().getBackups(database);
            for (DatabaseBackup backup : backups) {
                try {
                    this.launcherPersistence.getGamePersister().deleteBackup(backup);
                }
                catch (GamePersistenceException gpe) {
                    throw new LauncherException(LauncherExceptionCode.ERR_IO);
                }
            }
        }
    }

    @Override
    public void updateDatabaseAndBackupsView(String database) {
        int gamesTotal = 0;
        try {
            gamesTotal = this.launcherPersistence.getGamePersister().getGames(database).size();
        }
        catch (GamePersistenceException gamePersistenceException) {
            // empty catch block
        }
        int backupsTotal = this.launcherPersistence.getGamePersister().getBackups(database).size();
        this.view.updateDatabaseAndBackups(database, gamesTotal, backupsTotal);
    }

    @Override
    public void updateDatabaseInfoView() {
        DatabaseInfo databaseInfo = this.getDatabaseInfo(this.databases);
        this.view.updateDatabaseInfo(databaseInfo);
    }

    @Override
    public DatabaseInfo getDatabaseInfo(Set<String> databases) {
        int totalDatabases = databases.size();
        int totalGames = 0;
        int totalBackups = 0;
        GamePersister persister = this.launcherPersistence.getGamePersister();
        for (String database : databases) {
            try {
                totalGames += persister.getGames(database).size();
                totalBackups += persister.getBackups(database).size();
            }
            catch (GamePersistenceException gamePersistenceException) {}
        }
        return new DatabaseInfo(totalDatabases, totalGames, totalBackups);
    }

    @Override
    public void onRequestDatabaseBackupsScreen(String database) {
        Set<DatabaseBackup> backups = this.launcherPersistence.getGamePersister().getBackups(database);
        TreeSet<DatabaseBackup> sortedBackups = new TreeSet<DatabaseBackup>((b1, b2) -> b1.getTimestamp().compareTo(b2.getTimestamp()));
        sortedBackups.addAll(backups);
        this.databaseBackupsPresenterFactory.create(this, database, sortedBackups).onRequestDatabaseBackupsScreen(this.currentLanguage, this.currentRightToLeft);
    }

    @Override
    public void viewRestoredDatabase(String database) throws LauncherException {
        this.mainPresenter.onViewUpdatedDatabase(database);
    }

    private int getTotalGamesInDatabase(String database) {
        int total = 0;
        try {
            total = this.launcherPersistence.getGamePersister().getGames(database).size();
        }
        catch (GamePersistenceException gamePersistenceException) {
            // empty catch block
        }
        return total;
    }
}

