/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.presenter;

import com.google.inject.Inject;
import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.patch.PatchException;
import info.msxlaunchers.openmsx.launcher.patch.PatchExceptionIssue;
import info.msxlaunchers.openmsx.launcher.patch.PatchMethod;
import info.msxlaunchers.openmsx.launcher.patch.PatcherProvider;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherExceptionCode;
import info.msxlaunchers.openmsx.launcher.ui.presenter.PatcherPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.PatcherView;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

class PatcherPresenterImpl
implements PatcherPresenter {
    private final PatcherView view;
    private final PatcherProvider patcherProvider;

    @Inject
    public PatcherPresenterImpl(PatcherView view, PatcherProvider patcherProvider) {
        this.view = view;
        this.patcherProvider = patcherProvider;
    }

    @Override
    public void onRequestIPSPatcherScreen(Language currentLanguage, boolean currentRightToLeft) {
        this.view.displayScreen(currentLanguage, currentRightToLeft);
    }

    @Override
    public boolean onValidate(String fileToPatch, String patchFile, boolean useTargetFile, String targetFile, boolean ipsPatchMethod, boolean skipChecksumValidation, String checksum) throws LauncherException {
        Path patchFilePath = Paths.get(this.checkIfEmpty(patchFile, LauncherExceptionCode.ERR_CANNOT_LOCATE_FILE), new String[0]);
        this.validateThatFileExists(patchFilePath);
        Path fileToPatchPath = Paths.get(this.checkIfEmpty(fileToPatch, LauncherExceptionCode.ERR_CANNOT_LOCATE_FILE), new String[0]);
        this.validateThatFileExists(fileToPatchPath);
        if (ipsPatchMethod && !skipChecksumValidation) {
            this.checkIfEmpty(checksum, LauncherExceptionCode.ERR_EMPTY_CHECKSUM);
        }
        if (useTargetFile) {
            this.checkIfEmpty(targetFile, LauncherExceptionCode.ERR_IO);
            if (Files.exists(Paths.get(targetFile, new String[0]), new LinkOption[0]) && !this.view.confirmTargetFileReplacement()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void onRequestPatchFileActionForIPS(String patchFile, String fileToPatch, boolean useTargetFile, String targetFile, boolean skipChecksumValidation, String checksum) throws LauncherException {
        this.patch(patchFile, fileToPatch, useTargetFile, targetFile, skipChecksumValidation, checksum, PatchMethod.IPS);
    }

    @Override
    public void onRequestPatchFileActionForUPS(String patchFile, String fileToPatch, boolean useTargetFile, String targetFile, boolean skipChecksumValidation) throws LauncherException {
        this.patch(patchFile, fileToPatch, useTargetFile, targetFile, skipChecksumValidation, null, PatchMethod.UPS);
    }

    private void patch(String patchFile, String fileToPatch, boolean useTargetFile, String targetFile, boolean skipChecksumValidation, String checksum, PatchMethod patchMethod) throws LauncherException {
        block6: {
            Path patchFilePath = Paths.get(patchFile, new String[0]);
            Path fileToPatchPath = Paths.get(fileToPatch, new String[0]);
            Path targetFilePath = useTargetFile ? Paths.get(targetFile, new String[0]) : null;
            try {
                this.patcherProvider.get(patchMethod).patch(fileToPatchPath, patchFilePath, targetFilePath, skipChecksumValidation, checksum);
            }
            catch (PatchException pe) {
                PatchExceptionIssue issue = pe.getIssue();
                if (issue.equals((Object)PatchExceptionIssue.FILE_TO_PATCH_NOT_PATCHABLE)) {
                    throw new LauncherException(LauncherExceptionCode.ERR_FILE_TO_PATCH_NOT_PATCHABLE);
                }
                if (issue.equals((Object)PatchExceptionIssue.INVALID_PATCH_FILE)) {
                    throw new LauncherException(LauncherExceptionCode.ERR_INVALID_PATCH_FILE);
                }
                if (issue.equals((Object)PatchExceptionIssue.SOURCE_FILE_CHECKSUM_NOT_MATCH)) {
                    throw new LauncherException(LauncherExceptionCode.ERR_SOURCE_FILE_CHECKSUM_NOT_MATCH);
                }
                if (issue.equals((Object)PatchExceptionIssue.ZIP_SOURCE_FILE_CANNOT_BE_PATCHED_DIRECTLY)) {
                    throw new LauncherException(LauncherExceptionCode.ERR_ZIP_SOURCE_FILE_CANNOT_BE_PATCHED_DIRECTLY);
                }
                if (!issue.equals((Object)PatchExceptionIssue.TARGET_FILE_CANNOT_WRITE) && !issue.equals((Object)PatchExceptionIssue.IO)) break block6;
                throw new LauncherException(LauncherExceptionCode.ERR_IO);
            }
        }
    }

    private void validateThatFileExists(Path filePath) throws LauncherException {
        if (Files.notExists(filePath, new LinkOption[0])) {
            throw new LauncherException(LauncherExceptionCode.ERR_CANNOT_LOCATE_FILE, filePath.toString());
        }
    }

    private String checkIfEmpty(String string, LauncherExceptionCode errorCode) throws LauncherException {
        if (Utils.isEmpty(string)) {
            throw new LauncherException(errorCode);
        }
        return string;
    }
}

