/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.presenter;

import com.google.inject.Inject;
import info.msxlaunchers.openmsx.common.ExternalLinksUtils;
import info.msxlaunchers.openmsx.launcher.data.game.DatabaseItem;
import info.msxlaunchers.openmsx.launcher.data.game.Game;
import info.msxlaunchers.openmsx.launcher.data.game.RelatedGame;
import info.msxlaunchers.openmsx.launcher.data.repository.RepositoryGame;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersister;
import info.msxlaunchers.openmsx.launcher.persistence.settings.SettingsPersister;
import info.msxlaunchers.openmsx.launcher.related.RelatedGamesFactory;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherExceptionCode;
import info.msxlaunchers.openmsx.launcher.ui.presenter.MainPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.RelatedGamesPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.RelatedGamesView;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;

final class RelatedGamesPresenterImpl
implements RelatedGamesPresenter {
    private final RelatedGamesFactory relatedGamesFactory;
    private final RelatedGamesView view;
    private final String scrrenshotsPath;
    private final GamePersister gamePersister;
    private final MainPresenter mainPresenter;

    @Inject
    RelatedGamesPresenterImpl(RelatedGamesFactory relatedGamesFactory, RelatedGamesView view, SettingsPersister settingsPersister, GamePersister gamePersister, MainPresenter mainPresenter) throws IOException {
        this.relatedGamesFactory = relatedGamesFactory;
        this.view = view;
        this.scrrenshotsPath = settingsPersister.getSettings().getScreenshotsFullPath();
        this.gamePersister = gamePersister;
        this.mainPresenter = mainPresenter;
    }

    @Override
    public void onRequestRelatedGamesScreen(Game game, Map<String, RepositoryGame> repositoryInfoMap, Language currentLanguage, boolean currentRightToLeft) throws LauncherException {
        List<RelatedGame> relatedGames;
        try {
            relatedGames = this.relatedGamesFactory.create(repositoryInfoMap).findRelated(game);
        }
        catch (IOException ioe) {
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
        try {
            relatedGames = this.gamePersister.getRelatedGamesWithLauncherLinks(relatedGames);
        }
        catch (GamePersistenceException gpe) {
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
        this.view.displayRelatedGamesScreen(game.getName(), relatedGames, currentLanguage, currentRightToLeft);
    }

    @Override
    public void onRequestHighlightGameInLauncher(DatabaseItem databaseItem) throws LauncherException {
        this.mainPresenter.onSelectDatabaseItem(databaseItem);
    }

    @Override
    public Path getScreenshotPath(int msxGenId) {
        String[] variations = new String[]{"b", "b-en", "b-a"};
        for (int index = 0; index < variations.length; ++index) {
            Path path = Paths.get(this.scrrenshotsPath, msxGenId + variations[index] + ".png");
            if (!path.toFile().exists()) continue;
            return path;
        }
        return Paths.get(this.scrrenshotsPath, msxGenId + "b.png");
    }

    @Override
    public boolean isGenerationMSXIdValid(RelatedGame relatedGame) {
        return ExternalLinksUtils.isGenerationMSXIdValid(relatedGame.getMSXGenId());
    }

    @Override
    public String getGenerationMSXURL(RelatedGame relatedGame) {
        return ExternalLinksUtils.getGenerationMSXURL(relatedGame.getMSXGenId());
    }

    @Override
    public String getYouTubeURL(String gameName) {
        return ExternalLinksUtils.getYouTubeSearchURL(gameName);
    }
}

