/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.presenter;

import com.google.inject.Inject;
import info.msxlaunchers.openmsx.game.scan.Scanner;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceExceptionIssue;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherExceptionCode;
import info.msxlaunchers.openmsx.launcher.ui.presenter.MainPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.ScannerPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.ScannerView;
import info.msxlaunchers.openmsx.machine.InvalidMachinesDirectoryException;
import info.msxlaunchers.openmsx.machine.MachineLister;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;

final class ScannerPresenterImpl
implements ScannerPresenter {
    private final ScannerView view;
    private final MainPresenter mainPresenter;
    private final Scanner scanner;
    private final MachineLister machineLister;

    @Inject
    ScannerPresenterImpl(ScannerView view, MainPresenter mainPresenter, Scanner scanner, MachineLister machineLister) throws IOException {
        this.view = Objects.requireNonNull(view);
        this.mainPresenter = Objects.requireNonNull(mainPresenter);
        this.scanner = Objects.requireNonNull(scanner);
        this.machineLister = Objects.requireNonNull(machineLister);
    }

    @Override
    public void onRequestFillDatabaseScreen(Set<String> databases, String currentDatabase, Language currentLanguage, boolean currentRightToLeft) throws LauncherException {
        try {
            this.view.displayFillDatabase(currentLanguage, databases, currentDatabase, this.machineLister.get(), Language.isRightToLeft(currentLanguage));
        }
        catch (InvalidMachinesDirectoryException imde) {
            throw new LauncherException(LauncherExceptionCode.ERR_INVALID_MACHINES_DIRECTORY);
        }
        catch (IOException e) {
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
    }

    @Override
    public int onRequestFillDatabaseAction(String[] paths, boolean traverseSubDirectories, String database, boolean newDatabase, boolean append, String machine, boolean searchROM, boolean searchDisk, boolean searchTape, boolean searchLaserdisc, boolean getNameFromOpenMSXDatabase, boolean backupDatabase) throws LauncherException {
        int totalFound = 0;
        try {
            totalFound = this.scanner.scan(paths, traverseSubDirectories, database, newDatabase, append, machine, searchROM, searchDisk, searchTape, searchLaserdisc, getNameFromOpenMSXDatabase, backupDatabase);
        }
        catch (GamePersistenceException gpe) {
            if (!gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.GAME_WITH_NULL_NAME)) {
                if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.DATABASE_NULL_NAME)) {
                    throw new LauncherException(LauncherExceptionCode.ERR_DATABASE_NULL_NAME);
                }
                if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.DATABASE_MAX_BACKUPS_REACHED)) {
                    throw new LauncherException(LauncherExceptionCode.ERR_DATABASE_MAX_BACKUPS_REACHED, database);
                }
                if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.DATABASE_ALREADY_EXISTS)) {
                    throw new LauncherException(LauncherExceptionCode.ERR_DATABASE_ALREADY_EXISTS, database);
                }
                if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.DATABASE_NOT_FOUND)) {
                    throw new LauncherException(LauncherExceptionCode.ERR_DATABASE_NOT_FOUND, database);
                }
            }
        }
        catch (IOException e) {
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
        return totalFound;
    }

    @Override
    public void onRequestInterruptFillDatabaseProcess() {
        this.scanner.interrupt();
    }

    @Override
    public void onViewUpdatedDatabase(String database) throws LauncherException {
        this.mainPresenter.onViewUpdatedDatabase(database);
    }
}

