/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.platform;

import com.google.inject.Inject;
import com.google.inject.Provider;
import info.msxlaunchers.openmsx.common.OSUtils;
import info.msxlaunchers.openmsx.launcher.ui.presenter.MainPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.platform.BSDViewProperties;
import info.msxlaunchers.openmsx.launcher.ui.view.platform.LinuxViewProperties;
import info.msxlaunchers.openmsx.launcher.ui.view.platform.MacViewProperties;
import info.msxlaunchers.openmsx.launcher.ui.view.platform.OtherPlatformViewProperties;
import info.msxlaunchers.openmsx.launcher.ui.view.platform.PlatformViewProperties;
import info.msxlaunchers.openmsx.launcher.ui.view.platform.WindowsViewProperties;

public class PlatformViewPropertiesProvider
implements Provider<PlatformViewProperties> {
    private final MainPresenter mainPresenter;

    @Inject
    PlatformViewPropertiesProvider(MainPresenter mainPresenter) {
        this.mainPresenter = mainPresenter;
    }

    public PlatformViewProperties get() {
        if (OSUtils.isWindows()) {
            return new WindowsViewProperties();
        }
        if (OSUtils.isMac()) {
            return new MacViewProperties(this.mainPresenter);
        }
        if (OSUtils.isLinux()) {
            return new LinuxViewProperties();
        }
        if (OSUtils.isBSD()) {
            return new BSDViewProperties();
        }
        return new OtherPlatformViewProperties();
    }
}

