/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing;

import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.ui.presenter.DraggedAndDroppedGamesPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.FillDatabaseTask;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.FillDatabaseTaskExecutor;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.GlobalSwingContext;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.MainWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.MessageBoxUtil;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.ProgressWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.language.LanguageDisplayFactory;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class AddDraggedAndDroppedGamesWindow
extends JDialog
implements ActionListener {
    private final DraggedAndDroppedGamesPresenter presenter;
    private String currentDatabase;
    private final Language language;
    private final Map<String, String> messages;
    private final boolean rightToLeft;
    private final Component mainWindow;
    private final File[] files;
    private final Set<String> machines;
    private JComboBox<String> profileNamesComboBox;
    private JCheckBox backupDatabase;
    private JComboBox<String> machinesComboBox;
    private JButton okButton;
    private JButton cancelButton;
    private final Dimension fileListDimension = new Dimension(350, 150);

    public AddDraggedAndDroppedGamesWindow(DraggedAndDroppedGamesPresenter presenter, String currentDatabase, Language language, boolean rightToLeft, File[] files, Set<String> machines) {
        this.presenter = presenter;
        this.currentDatabase = currentDatabase;
        this.language = language;
        this.messages = LanguageDisplayFactory.getDisplayMessages(this.getClass(), language);
        this.rightToLeft = rightToLeft;
        this.mainWindow = GlobalSwingContext.getIntance().getMainWindow();
        this.files = files;
        this.machines = machines;
    }

    public void displayScreen() {
        this.setDefaultCloseOperation(2);
        this.setTitle(this.messages.get("ADD_GAMES"));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(contentPane);
        contentPane.setLayout(new BoxLayout(contentPane, 3));
        JPanel filesPane = new JPanel();
        filesPane.setBorder(BorderFactory.createTitledBorder(this.messages.get("FILES_AND_DIRS")));
        DefaultListModel<String> fileListModel = new DefaultListModel<String>();
        JList fileList = new JList(fileListModel);
        for (File file : this.files) {
            fileListModel.addElement(file.getAbsolutePath());
        }
        JScrollPane fileListScrollBar = new JScrollPane(fileList);
        fileListScrollBar.setPreferredSize(this.fileListDimension);
        filesPane.add(fileListScrollBar);
        contentPane.add(filesPane);
        JPanel optionsPane = new JPanel();
        optionsPane.setBorder(BorderFactory.createTitledBorder(this.messages.get("DATABASE_OPTIONS")));
        optionsPane.setLayout(new BoxLayout(optionsPane, 3));
        JPanel profileNamePane = new JPanel();
        JLabel lblProfileNameIn = new JLabel(this.messages.get("PROFILE_NAME"));
        profileNamePane.add(lblProfileNameIn);
        String[] profileNames = new String[]{this.messages.get("USE_FILENAME"), this.messages.get("USE_COMMON_NAME")};
        this.profileNamesComboBox = new JComboBox<String>(profileNames);
        profileNamePane.add(this.profileNamesComboBox);
        optionsPane.add(profileNamePane);
        JPanel backupDatabasePane = new JPanel();
        this.backupDatabase = new JCheckBox(this.messages.get("BACKUP_EXISTING_DATABASE"));
        backupDatabasePane.add(this.backupDatabase);
        optionsPane.add(backupDatabasePane);
        contentPane.add(optionsPane);
        JPanel machinesPane = new JPanel();
        machinesPane.setBorder(BorderFactory.createTitledBorder(this.messages.get("MACHINE")));
        JLabel machinesLabel = new JLabel(this.messages.get("MACHINE"));
        machinesPane.add(machinesLabel);
        this.machinesComboBox = new JComboBox<String>(Utils.getSortedCaseInsensitiveArray(this.machines));
        machinesPane.add(this.machinesComboBox);
        contentPane.add(machinesPane);
        JPanel buttonsPane = new JPanel();
        buttonsPane.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = new JButton(this.messages.get("OK"));
        this.okButton.addActionListener(this);
        this.okButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        buttonsPane.add(this.okButton);
        this.cancelButton = new JButton(this.messages.get("CANCEL"));
        this.cancelButton.addActionListener(this);
        this.cancelButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        buttonsPane.add(this.cancelButton);
        contentPane.add(buttonsPane);
        if (this.rightToLeft) {
            filesPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            filesPane.setLayout(new FlowLayout(2, 5, 5));
            optionsPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            profileNamePane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            profileNamePane.setLayout(new FlowLayout(2, 5, 5));
            backupDatabasePane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            backupDatabasePane.setLayout(new FlowLayout(2, 5, 5));
            this.backupDatabase.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            machinesPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            machinesPane.setLayout(new FlowLayout(2, 5, 5));
            buttonsPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        } else {
            filesPane.setLayout(new FlowLayout(0, 5, 5));
            profileNamePane.setLayout(new FlowLayout(0, 5, 5));
            backupDatabasePane.setLayout(new FlowLayout(0, 5, 5));
            machinesPane.setLayout(new FlowLayout(0, 5, 5));
        }
        this.pack();
        this.setLocationRelativeTo(this.mainWindow);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.addDraggedAndDroppedGames();
        } else if (source == this.cancelButton) {
            this.dispose();
        }
    }

    private void addDraggedAndDroppedGames() {
        FillDatabaseTask fillDatabaseTask = new FillDatabaseTask(new AddDraggedAndDroppedGamesExecutor(), this.mainWindow, this.messages, this.rightToLeft);
        ProgressWindow progressWindow = new ProgressWindow(fillDatabaseTask, this.language, this.rightToLeft, this);
        progressWindow.showProgress();
        if (!fillDatabaseTask.isError()) {
            try {
                this.presenter.onUpdateViewedDatabase(this.currentDatabase);
            }
            catch (LauncherException le) {
                MessageBoxUtil.showErrorMessageBox(this.mainWindow, le, this.messages, this.rightToLeft);
            }
            this.dispose();
            MessageBoxUtil.showInformationMessageBox(this.mainWindow, this.messages.get("TOTAL_ADDED_TO_DATABASE") + ": " + fillDatabaseTask.getResult(), this.messages, this.rightToLeft);
        }
    }

    private class AddDraggedAndDroppedGamesExecutor
    implements FillDatabaseTaskExecutor {
        private AddDraggedAndDroppedGamesExecutor() {
        }

        @Override
        public int execute() throws LauncherException {
            return AddDraggedAndDroppedGamesWindow.this.presenter.onRequestAddDraggedAndDroppedGamesAddAction(AddDraggedAndDroppedGamesWindow.this.profileNamesComboBox.getSelectedIndex() == 1, AddDraggedAndDroppedGamesWindow.this.backupDatabase.isSelected(), AddDraggedAndDroppedGamesWindow.this.machinesComboBox.getSelectedItem().toString());
        }

        @Override
        public void interrupt() {
            AddDraggedAndDroppedGamesWindow.this.presenter.onRequestInterruptFillDatabaseProcess();
        }
    }
}

