/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing;

import info.msxlaunchers.openmsx.launcher.data.backup.DatabaseBackup;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.ui.presenter.DatabaseBackupsPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.GlobalSwingContext;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.MainWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.JTableButtonColumn;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.MessageBoxUtil;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.images.Icons;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.language.LanguageDisplayFactory;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class DatabaseBackupsWindow
extends JDialog
implements ActionListener {
    private final DatabaseBackupsPresenter presenter;
    private final Map<String, String> messages;
    private final boolean rightToLeft;
    private final Component mainWindow;
    private final Set<DatabaseBackup> backups;
    private final DateFormat dateFormat;
    private final DatabaseBackupsWindow thisWindow = this;
    private LabeledTableModel tableModel;
    private JButton backupNowButton;
    private JButton okButton;

    public DatabaseBackupsWindow(DatabaseBackupsPresenter presenter, Language language, boolean rightToLeft, Set<DatabaseBackup> backups) {
        this.presenter = presenter;
        this.rightToLeft = rightToLeft;
        this.mainWindow = GlobalSwingContext.getIntance().getMainWindow();
        this.messages = LanguageDisplayFactory.getDisplayMessages(this.getClass(), language);
        this.backups = backups;
        this.dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.forLanguageTag(language.getLocaleName().replace('_', '-')));
    }

    public void display() {
        this.setDefaultCloseOperation(2);
        this.setTitle(this.messages.get("BACKUPS"));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(contentPane);
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel backupsTablePane = new JPanel();
        backupsTablePane.setLayout(new BoxLayout(backupsTablePane, 1));
        backupsTablePane.setBorder(BorderFactory.createTitledBorder(this.messages.get("BACKUPS")));
        JPanel tablePane = new JPanel();
        this.tableModel = new LabeledTableModel(this.backups.size());
        JTable table = new JTable(this.tableModel);
        table.setRowSelectionAllowed(false);
        table.setTableHeader(null);
        table.setPreferredScrollableViewportSize(new Dimension(350, 82));
        table.getColumnModel().getColumn(0).setPreferredWidth(330);
        table.getColumnModel().getColumn(1).setPreferredWidth(10);
        table.getColumnModel().getColumn(2).setPreferredWidth(10);
        AbstractAction backupAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DatabaseBackupsWindow.this.restoreTableRow(Integer.parseInt(e.getActionCommand()));
                }
                catch (LauncherException le) {
                    MessageBoxUtil.showErrorMessageBox((Component)DatabaseBackupsWindow.this.thisWindow, le, (Map<String, String>)DatabaseBackupsWindow.this.messages, DatabaseBackupsWindow.this.rightToLeft);
                }
            }
        };
        new JTableButtonColumn(table, backupAction, 1, Icons.RESTORE_SMALL.getImageIcon(), this.messages.get("RESTORE"));
        AbstractAction deleteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DatabaseBackupsWindow.this.removeRowFromTable(Integer.parseInt(e.getActionCommand()));
                }
                catch (LauncherException le) {
                    MessageBoxUtil.showErrorMessageBox((Component)DatabaseBackupsWindow.this.thisWindow, le, (Map<String, String>)DatabaseBackupsWindow.this.messages, DatabaseBackupsWindow.this.rightToLeft);
                }
            }
        };
        new JTableButtonColumn(table, deleteAction, 2, Icons.DELETE_SMALL.getImageIcon(), this.messages.get("DELETE"));
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setVerticalScrollBarPolicy(22);
        tablePane.add(scrollPane);
        backupsTablePane.add(tablePane);
        JPanel backupButtonPane = new JPanel();
        this.backupNowButton = new JButton(this.messages.get("BACKUP_NOW"));
        this.backupNowButton.addActionListener(this);
        backupButtonPane.add(this.backupNowButton);
        backupsTablePane.add(backupButtonPane);
        contentPane.add(backupsTablePane);
        this.backups.stream().forEach(db -> this.tableModel.addItem(db.getTimestamp(), this.dateFormat.format(db.getTimestamp())));
        JPanel buttonsPane = new JPanel();
        buttonsPane.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = new JButton(this.messages.get("OK"));
        this.okButton.addActionListener(this);
        this.okButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        buttonsPane.add(this.okButton);
        contentPane.add(buttonsPane);
        if (this.rightToLeft) {
            backupsTablePane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            table.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            DefaultTableCellRenderer tableRenderer = new DefaultTableCellRenderer();
            tableRenderer.setHorizontalAlignment(4);
            table.getColumnModel().getColumn(0).setCellRenderer(tableRenderer);
            backupButtonPane.setLayout(new FlowLayout(2));
        } else {
            backupButtonPane.setLayout(new FlowLayout(0));
        }
        this.pack();
        this.setLocationRelativeTo(this.mainWindow);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.dispose();
        } else if (source == this.backupNowButton) {
            this.backupDatabaseNow();
        }
    }

    private void backupDatabaseNow() {
        try {
            DatabaseBackup databaseBackup = this.presenter.onRequestBackupDatabase();
            this.tableModel.addItem(databaseBackup.getTimestamp(), this.dateFormat.format(databaseBackup.getTimestamp()));
            this.presenter.updateDatabaseAndBackupsView(databaseBackup);
            this.presenter.updateDatabaseInfoView();
        }
        catch (LauncherException le) {
            MessageBoxUtil.showErrorMessageBox((Component)this.thisWindow, le, this.messages, this.rightToLeft);
        }
    }

    private void restoreTableRow(int index) throws LauncherException {
        if (MessageBoxUtil.showYesNoMessageBox((Component)this, this.messages.get("RESTORE_CONFIRMATION"), this.messages, this.rightToLeft) == 0) {
            Timestamp timestamp = this.tableModel.getTimestamp(index);
            this.presenter.onRequestRestoreBackup(timestamp);
            this.presenter.updateDatabaseAndBackupsView(timestamp);
            this.presenter.updateDatabaseInfoView();
            this.presenter.viewRestoredDatabase(timestamp);
            this.tableModel.removeRow(index);
        }
    }

    private void removeRowFromTable(int index) throws LauncherException {
        if (MessageBoxUtil.showYesNoMessageBox((Component)this, this.messages.get("DELETE_CONFIRMATION"), this.messages, this.rightToLeft) == 0) {
            Timestamp timestamp = this.tableModel.getTimestamp(index);
            this.presenter.onRequestDeleteBackup(timestamp);
            this.presenter.updateDatabaseAndBackupsView(timestamp);
            this.presenter.updateDatabaseInfoView();
            this.tableModel.removeRow(index);
        }
    }

    private class LabeledTableModel
    extends TableModel {
        private final List<Timestamp> timestamps;

        LabeledTableModel(int size) {
            this.timestamps = new ArrayList<Timestamp>(size);
        }

        void addItem(Timestamp timestamp, String localizedTimestamp) {
            this.addRow(new Object[]{localizedTimestamp});
            this.timestamps.add(timestamp);
        }

        @Override
        public void removeRow(int index) {
            super.removeRow(index);
            this.timestamps.remove(index);
        }

        Timestamp getTimestamp(int index) {
            return this.timestamps.get(index);
        }
    }

    private class TableModel
    extends DefaultTableModel {
        private final String[] columnNames = new String[]{"", "", ""};

        private TableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col > 0;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }
    }
}

