/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing;

import info.msxlaunchers.openmsx.common.FileTypeUtils;
import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.openmsx.launcher.data.game.Game;
import info.msxlaunchers.openmsx.launcher.data.game.constants.Genre;
import info.msxlaunchers.openmsx.launcher.data.game.constants.MSXGeneration;
import info.msxlaunchers.openmsx.launcher.data.game.constants.Medium;
import info.msxlaunchers.openmsx.launcher.data.game.constants.Sound;
import info.msxlaunchers.openmsx.launcher.data.repository.RepositoryGame;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.ui.presenter.GamePropertiesPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.GlobalSwingContext;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.MainWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.HyperLink;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.JTextFieldBorderless;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.images.Icons;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.language.LanguageDisplayFactory;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class GamePropertiesWindow
extends JDialog
implements ActionListener {
    private final GamePropertiesPresenter presenter;
    private final Game game;
    private final RepositoryGame repositoryGame;
    private final int knownDumps;
    private final List<String> fileGroup;
    private final Map<String, String> messages;
    private final boolean rightToLeft;
    private final Component mainWindow;
    private JPanel tablePane = null;
    private GridBagLayout tableLayout = null;
    private GridBagConstraints labelConstraints = null;
    private GridBagConstraints valueConstraints = null;
    private JButton okButton;
    private static final String SEPARATOR = ", ";
    private static final Map<String, String> countryFlag = new HashMap<String, String>();
    private static final Map<String, String> generationImage;

    public GamePropertiesWindow(GamePropertiesPresenter presenter, Game game, RepositoryGame repositoryGame, int knownDumps, List<String> fileGroup, Language language, boolean rightToLeft) {
        this.presenter = presenter;
        this.game = game;
        this.fileGroup = fileGroup;
        this.repositoryGame = repositoryGame;
        this.knownDumps = knownDumps;
        this.rightToLeft = rightToLeft;
        this.messages = LanguageDisplayFactory.getDisplayMessages(this.getClass(), language);
        this.mainWindow = GlobalSwingContext.getIntance().getMainWindow();
    }

    public void display() {
        this.setDefaultCloseOperation(2);
        this.setTitle(this.messages.get("PROPERTIES"));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(contentPane);
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        this.tablePane = new JPanel();
        if (this.rightToLeft) {
            this.tablePane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        this.tableLayout = new GridBagLayout();
        this.tablePane.setLayout(this.tableLayout);
        this.labelConstraints = new GridBagConstraints();
        this.valueConstraints = new GridBagConstraints();
        this.valueConstraints.fill = 2;
        this.valueConstraints.anchor = 18;
        this.valueConstraints.weightx = 1.0;
        this.valueConstraints.gridwidth = 0;
        this.valueConstraints.insets = new Insets(2, 2, 2, 4);
        this.labelConstraints = (GridBagConstraints)this.valueConstraints.clone();
        this.labelConstraints.weightx = 0.0;
        this.labelConstraints.gridwidth = 1;
        this.addPropertyToDisplay(this.messages.get("NAME"), this.game.getName());
        if (this.repositoryGame != null) {
            this.addPropertyToDisplay(this.messages.get("COMMON_NAME"), this.repositoryGame.getTitle());
        }
        File mainFile = new File(FileTypeUtils.getMainFile(this.game.getRomA(), this.game.getRomB(), this.game.getDiskA(), this.game.getDiskB(), this.game.getTape(), this.game.getHarddisk(), this.game.getLaserdisc(), this.game.getTclScript()));
        this.addPropertyToDisplay(this.messages.get("FILE"), mainFile.getAbsolutePath());
        this.addPropertyToDisplay(this.messages.get("MEDIUM"), this.getMedium());
        if (this.repositoryGame != null) {
            this.addPropertyToDisplay(this.messages.get("SYSTEM"), this.repositoryGame.getSystem());
            this.addPropertyToDisplay(this.messages.get("KNOWN_DUMPS"), String.valueOf(this.knownDumps));
        }
        if (this.game.getSize() > 0L) {
            this.addPropertyToDisplay(this.messages.get("SIZE"), Utils.getString(this.game.getSize() / 1024L) + " KB");
        }
        this.addPropertyToDisplay("SHA1", this.game.getSha1Code(), true);
        if (this.repositoryGame != null) {
            this.addPropertyToDisplay(this.messages.get("COMPANY"), this.repositoryGame.getCompany());
            this.addPropertyToDisplay(this.messages.get("YEAR"), this.repositoryGame.getYear());
            this.addPropertyToDisplayWithIcon(this.messages.get("COUNTRY"), this.repositoryGame.getCountry(), countryFlag);
            if (this.game.isROM()) {
                this.addPropertyToDisplay(this.messages.get("MAPPER"), this.repositoryGame.getMapper());
            }
            this.addPropertyToDisplay(this.messages.get("START"), this.repositoryGame.getStart());
            this.addPropertyToDisplay(this.messages.get("DUMP"), this.repositoryGame.getOriginalText());
            this.addPropertyToDisplay(this.messages.get("REMARK"), this.repositoryGame.getRemark());
        }
        this.addPropertyToDisplayAsIcon(this.messages.get("GENERATION"), this.getGenerationList(this.game), generationImage);
        this.addPropertyToDisplay(this.messages.get("SOUND"), this.getSound(this.game));
        this.addPropertyToDisplay(this.messages.get("GENRE"), this.getGenre(this.game));
        if (this.presenter.isGenerationMSXIdValid(this.game)) {
            this.addLinkToDisplay("Generation-MSX ID", Utils.getString(this.game.getMsxGenID()), this.presenter.getGenerationMSXURL(this.game), true);
        }
        JPanel buttonsPane = new JPanel();
        buttonsPane.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = new JButton(this.messages.get("OK"));
        this.okButton.addActionListener(this);
        this.okButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        buttonsPane.add(this.okButton);
        contentPane.add(this.tablePane);
        contentPane.add(buttonsPane);
        this.pack();
        this.setLocationRelativeTo(this.mainWindow);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.dispose();
        }
    }

    private void addPropertyToDisplayWithIcon(String attribute, String value, Map<String, String> valueToIcon) {
        String localizedValue;
        if (!Utils.isEmpty(value) && !Utils.isEmpty(localizedValue = this.messages.get(value))) {
            this.addAttribute(attribute, false);
            JLabel valueLabel = new JLabel();
            valueLabel.setIcon(Icons.valueOf(valueToIcon.get(value)).getImageIcon());
            valueLabel.setText(localizedValue);
            this.tableLayout.setConstraints(valueLabel, this.valueConstraints);
            this.tablePane.add(valueLabel);
            if (this.rightToLeft) {
                valueLabel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            }
        }
    }

    private void addPropertyToDisplayAsIcon(String attribute, List<String> values, Map<String, String> valueToIcon) {
        if (!values.isEmpty()) {
            this.addAttribute(attribute, false);
            JPanel valuePanel = new JPanel(new FlowLayout(3, 0, 1));
            for (String value : values) {
                JLabel valueLabel = new JLabel();
                valueLabel.setIcon(Icons.valueOf(valueToIcon.get(value)).getImageIcon());
                valuePanel.add(valueLabel);
                valuePanel.add(Box.createHorizontalStrut(8));
            }
            this.tableLayout.setConstraints(valuePanel, this.valueConstraints);
            this.tablePane.add(valuePanel);
            if (this.rightToLeft) {
                valuePanel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            }
        }
    }

    private void addPropertyToDisplay(String attribute, String value) {
        this.addPropertyToDisplay(attribute, value, false);
    }

    private void addPropertyToDisplay(String attribute, String value, boolean colonOnTheLeft) {
        if (!Utils.isEmpty(value)) {
            this.addAttribute(attribute, colonOnTheLeft);
            JTextFieldBorderless valueTextField = new JTextFieldBorderless(value);
            if (this.rightToLeft) {
                valueTextField.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            }
            this.tableLayout.setConstraints(valueTextField, this.valueConstraints);
            this.tablePane.add(valueTextField);
        }
    }

    private void addAttribute(String attribute, boolean colonOnTheLeft) {
        JLabel attributeLabel = this.rightToLeft && colonOnTheLeft ? new JLabel(":" + attribute) : new JLabel(attribute + ":");
        this.tableLayout.setConstraints(attributeLabel, this.labelConstraints);
        this.tablePane.add(attributeLabel);
        if (this.rightToLeft) {
            attributeLabel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
    }

    private void addLinkToDisplay(String attribute, String label, String address, boolean colonOnTheLeft) {
        JLabel attributeLabel = this.rightToLeft && colonOnTheLeft ? new JLabel(":" + attribute) : new JLabel(attribute + ":");
        this.tableLayout.setConstraints(attributeLabel, this.labelConstraints);
        this.tablePane.add(attributeLabel);
        JPanel linkPanel = new JPanel();
        linkPanel.setLayout(new FlowLayout(3, 0, 0));
        linkPanel.add(HyperLink.label(label).address(address).build());
        this.tableLayout.setConstraints(linkPanel, this.valueConstraints);
        this.tablePane.add(linkPanel);
        if (this.rightToLeft) {
            attributeLabel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            linkPanel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
    }

    private String getMedium(Game game) {
        String medium = null;
        medium = game.isROM() ? Medium.ROM.toString() : (game.isDisk() ? Medium.DISK.toString() : (game.isTape() ? Medium.TAPE.toString() : (game.isHarddisk() ? Medium.HARDDISK.toString() : (game.isLaserdisc() ? Medium.LASERDISC.toString() : ""))));
        return medium;
    }

    private String getMedium() {
        StringBuilder builder = new StringBuilder();
        if (this.game.isDisk() || this.game.isTape()) {
            builder.append(this.messages.get(this.getMedium(this.game))).append(" ").append(this.fileGroup.size()).append("x");
        }
        return builder.toString();
    }

    private List<String> getGenerationList(Game game) {
        ArrayList<String> generationList = new ArrayList<String>();
        if (game.isMSX()) {
            generationList.add(MSXGeneration.MSX.getDisplayName());
        }
        if (game.isMSX2()) {
            generationList.add(MSXGeneration.MSX2.getDisplayName());
        }
        if (game.isMSX2Plus()) {
            generationList.add(MSXGeneration.MSX2Plus.getDisplayName());
        }
        if (game.isTurboR()) {
            generationList.add(MSXGeneration.TURBO_R.getDisplayName());
        }
        return generationList;
    }

    private String getSound(Game game) {
        StringBuilder sound = new StringBuilder("");
        if (game.isPSG()) {
            sound.append(Sound.PSG.getDisplayName()).append(SEPARATOR);
        }
        if (game.isSCC()) {
            sound.append(Sound.SCC.getDisplayName()).append(SEPARATOR);
        }
        if (game.isSCCI()) {
            sound.append(Sound.SCC_I.getDisplayName()).append(SEPARATOR);
        }
        if (game.isPCM()) {
            sound.append(Sound.PCM.getDisplayName()).append(SEPARATOR);
        }
        if (game.isMSXMUSIC()) {
            sound.append(Sound.MSX_MUSIC.getDisplayName()).append(SEPARATOR);
        }
        if (game.isMSXAUDIO()) {
            sound.append(Sound.MSX_AUDIO.getDisplayName()).append(SEPARATOR);
        }
        if (game.isMoonsound()) {
            sound.append(Sound.MOONSOUND.getDisplayName()).append(SEPARATOR);
        }
        if (game.isMIDI()) {
            sound.append(Sound.MIDI.getDisplayName()).append(SEPARATOR);
        }
        if (sound.length() > 0) {
            sound.setLength(sound.length() - SEPARATOR.length());
        }
        return sound.toString();
    }

    private String getGenre(Game game) {
        StringBuilder genre = new StringBuilder("");
        if (game.getGenre1() != null && !game.getGenre1().equals(Genre.UNKNOWN)) {
            genre.append(game.getGenre1().getDisplayName());
            if (game.getGenre2() != null && !game.getGenre2().equals(Genre.UNKNOWN)) {
                genre.append(SEPARATOR).append(game.getGenre2().getDisplayName());
            }
        }
        return genre.toString();
    }

    static {
        countryFlag.put("BR", "FLAG_pt_BR");
        countryFlag.put("DE", "FLAG_de_DE");
        countryFlag.put("ES", "FLAG_es_ES");
        countryFlag.put("FR", "FLAG_fr_FR");
        countryFlag.put("GB", "FLAG_UK");
        countryFlag.put("HK", "FLAG_HK");
        countryFlag.put("IT", "FLAG_it_IT");
        countryFlag.put("JP", "FLAG_ja_JP");
        countryFlag.put("KR", "FLAG_ko_KR");
        countryFlag.put("KW", "FLAG_KW");
        countryFlag.put("NL", "FLAG_nl_NL");
        countryFlag.put("PT", "FLAG_PT");
        countryFlag.put("RU", "FLAG_ru_RU");
        countryFlag.put("SA", "FLAG_SA");
        countryFlag.put("SE", "FLAG_sv_SE");
        countryFlag.put("UK", "FLAG_UK");
        countryFlag.put("US", "FLAG_en_US");
        countryFlag.put("TW", "FLAG_zh_TW");
        countryFlag.put("CA", "FLAG_CA");
        countryFlag.put("EU", "FLAG_EU");
        generationImage = new HashMap<String, String>();
        generationImage.put(MSXGeneration.MSX.getDisplayName(), "GENERATION_MSX_LARGE");
        generationImage.put(MSXGeneration.MSX2.getDisplayName(), "GENERATION_MSX2_LARGE");
        generationImage.put(MSXGeneration.MSX2Plus.getDisplayName(), "GENERATION_MSX2P_LARGE");
        generationImage.put(MSXGeneration.TURBO_R.getDisplayName(), "GENERATION_TURBO_R_LARGE");
    }
}

