/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing;

import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.presenter.MachineUpdatePresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.GlobalSwingContext;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.MainWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.MessageBoxUtil;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.language.LanguageDisplayFactory;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;

public class MachineUpdateWindow
extends JDialog
implements ActionListener {
    private final MachineUpdatePresenter presenter;
    private final String database;
    private final Map<String, String> messages;
    private final boolean rightToLeft;
    private final Component mainWindow;
    private final Set<String> machines;
    private JRadioButton allDatabasesRadioButton;
    private JRadioButton changeAllMachinesRadioButton;
    private JComboBox<String> changeAllMachinesComboBox;
    private JRadioButton changeFromToMachineRadioButton;
    private JComboBox<String> changeFromMachineComboBox;
    private JComboBox<String> changeToMachineComboBox;
    private JCheckBox backupAffectedDatabasesCheckBox;
    private JButton okButton;
    private JButton cancelButton;

    public MachineUpdateWindow(MachineUpdatePresenter presenter, String database, Language language, boolean rightToLeft, Set<String> machines) {
        this.presenter = presenter;
        this.database = database;
        this.messages = LanguageDisplayFactory.getDisplayMessages(this.getClass(), language);
        this.rightToLeft = rightToLeft;
        this.mainWindow = GlobalSwingContext.getIntance().getMainWindow();
        this.machines = machines;
    }

    public void displayScreen() {
        this.setDefaultCloseOperation(2);
        this.setTitle(this.messages.get("CHANGE_MACHINE"));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(contentPane);
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel databasePane = new JPanel();
        databasePane.setBorder(BorderFactory.createTitledBorder(this.messages.get("DATABASE")));
        databasePane.setLayout(new GridLayout(0, 1));
        JRadioButton currentDatabaseRadioButton = new JRadioButton(this.messages.get("UPDATE_CURRENT_DATABASE") + " [" + this.database + "]");
        currentDatabaseRadioButton.setSelected(true);
        currentDatabaseRadioButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        databasePane.add(currentDatabaseRadioButton);
        this.allDatabasesRadioButton = new JRadioButton(this.messages.get("UPDATE_ALL_DATABASES"));
        this.allDatabasesRadioButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        databasePane.add(this.allDatabasesRadioButton);
        ButtonGroup databaseButtonGroup = new ButtonGroup();
        databaseButtonGroup.add(this.allDatabasesRadioButton);
        databaseButtonGroup.add(currentDatabaseRadioButton);
        contentPane.add(databasePane);
        JPanel machinesPane = new JPanel();
        machinesPane.setBorder(BorderFactory.createTitledBorder(this.messages.get("MACHINE")));
        GridBagLayout machinesLayout = new GridBagLayout();
        machinesPane.setLayout(machinesLayout);
        GridBagConstraints valueConstraints = new GridBagConstraints();
        valueConstraints.fill = 1;
        valueConstraints.anchor = 17;
        valueConstraints.weightx = 1.0;
        valueConstraints.gridwidth = 0;
        valueConstraints.insets = new Insets(2, 2, 2, 4);
        GridBagConstraints labelConstraints = (GridBagConstraints)valueConstraints.clone();
        labelConstraints.weightx = 0.0;
        labelConstraints.gridwidth = 1;
        this.changeAllMachinesRadioButton = new JRadioButton(this.messages.get("CHANGE_ALL_TO"));
        this.changeAllMachinesRadioButton.setSelected(true);
        this.changeAllMachinesRadioButton.addActionListener(this);
        machinesLayout.setConstraints(this.changeAllMachinesRadioButton, labelConstraints);
        machinesPane.add(this.changeAllMachinesRadioButton);
        this.changeAllMachinesComboBox = new JComboBox<String>(Utils.getSortedCaseInsensitiveArray(this.machines));
        machinesLayout.setConstraints(this.changeAllMachinesComboBox, valueConstraints);
        machinesPane.add(this.changeAllMachinesComboBox);
        this.changeFromToMachineRadioButton = new JRadioButton(this.messages.get("CHANGE_FROM"));
        this.changeFromToMachineRadioButton.addActionListener(this);
        machinesLayout.setConstraints(this.changeFromToMachineRadioButton, labelConstraints);
        machinesPane.add(this.changeFromToMachineRadioButton);
        this.changeFromMachineComboBox = new JComboBox<String>(Utils.getSortedCaseInsensitiveArray(this.machines));
        this.changeFromMachineComboBox.setEnabled(false);
        machinesLayout.setConstraints(this.changeFromMachineComboBox, valueConstraints);
        machinesPane.add(this.changeFromMachineComboBox);
        JLabel toLabel = new JLabel(this.messages.get("TO"));
        toLabel.setBorder(new EmptyBorder(0, 22, 0, 0));
        machinesLayout.setConstraints(toLabel, labelConstraints);
        machinesPane.add(toLabel);
        this.changeToMachineComboBox = new JComboBox<String>(Utils.getSortedCaseInsensitiveArray(this.machines));
        this.changeToMachineComboBox.setEnabled(false);
        machinesLayout.setConstraints(this.changeToMachineComboBox, valueConstraints);
        machinesPane.add(this.changeToMachineComboBox);
        ButtonGroup machinesButtonGroup = new ButtonGroup();
        machinesButtonGroup.add(this.changeAllMachinesRadioButton);
        machinesButtonGroup.add(this.changeFromToMachineRadioButton);
        contentPane.add(machinesPane);
        JPanel backupPane = new JPanel();
        this.backupAffectedDatabasesCheckBox = new JCheckBox(this.messages.get("BACKUP_AFFECTED_DATABASES"));
        this.backupAffectedDatabasesCheckBox.setSelected(true);
        backupPane.add(this.backupAffectedDatabasesCheckBox);
        contentPane.add(backupPane);
        JPanel buttonsPane = new JPanel();
        buttonsPane.setLayout(new FlowLayout(1, 8, 8));
        this.okButton = new JButton(this.messages.get("OK"));
        this.okButton.addActionListener(this);
        this.okButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        buttonsPane.add(this.okButton);
        this.cancelButton = new JButton(this.messages.get("CANCEL"));
        this.cancelButton.addActionListener(this);
        this.cancelButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        buttonsPane.add(this.cancelButton);
        contentPane.add(buttonsPane);
        if (this.rightToLeft) {
            databasePane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            currentDatabaseRadioButton.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            currentDatabaseRadioButton.setHorizontalTextPosition(11);
            this.allDatabasesRadioButton.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.allDatabasesRadioButton.setHorizontalTextPosition(11);
            machinesPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.changeAllMachinesRadioButton.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.changeAllMachinesRadioButton.setHorizontalTextPosition(11);
            this.changeFromToMachineRadioButton.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.changeFromToMachineRadioButton.setHorizontalTextPosition(11);
            backupPane.setLayout(new FlowLayout(2, 18, 12));
            this.backupAffectedDatabasesCheckBox.setHorizontalTextPosition(10);
            buttonsPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        } else {
            backupPane.setLayout(new FlowLayout(0, 18, 12));
        }
        this.pack();
        this.setLocationRelativeTo(this.mainWindow);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.changeAllMachinesRadioButton) {
            this.changeAllMachinesComboBox.setEnabled(true);
            this.changeFromMachineComboBox.setEnabled(false);
            this.changeToMachineComboBox.setEnabled(false);
        } else if (source == this.changeFromToMachineRadioButton) {
            this.changeAllMachinesComboBox.setEnabled(false);
            this.changeFromMachineComboBox.setEnabled(true);
            this.changeToMachineComboBox.setEnabled(true);
        } else if (source == this.okButton) {
            this.processMachineUpdateRequest();
        } else if (source == this.cancelButton) {
            this.dispose();
        }
    }

    private void processMachineUpdateRequest() {
        try {
            int totalUpdated = this.presenter.onRequestMachineUpdateAction(this.getToMachine(), this.getFromMachine(), this.getDatabase(), this.backupAffectedDatabasesCheckBox.isSelected());
            this.dispose();
            MessageBoxUtil.showInformationMessageBox(this.mainWindow, this.messages.get("TOTAL_UPDATED_PROFILES") + ": " + totalUpdated, this.messages, this.rightToLeft);
        }
        catch (LauncherException le) {
            MessageBoxUtil.showErrorMessageBox(this.mainWindow, le, this.messages, this.rightToLeft);
        }
    }

    private String getToMachine() {
        if (this.changeAllMachinesRadioButton.isSelected()) {
            return this.changeAllMachinesComboBox.getSelectedItem().toString();
        }
        return this.changeToMachineComboBox.getSelectedItem().toString();
    }

    private String getFromMachine() {
        if (this.changeAllMachinesRadioButton.isSelected()) {
            return null;
        }
        return this.changeFromMachineComboBox.getSelectedItem().toString();
    }

    private String getDatabase() {
        if (this.allDatabasesRadioButton.isSelected()) {
            return null;
        }
        return this.database;
    }
}

