/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing;

import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.openmsx.launcher.data.settings.Settings;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.presenter.SettingsPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.GlobalSwingContext;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.MainWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.WindowUtils;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.JComboBoxWithImages;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.MessageBoxUtil;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.images.Icons;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.language.LanguageDisplayFactory;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class SettingsWindow
extends JDialog
implements ActionListener {
    private final SettingsPresenter presenter;
    private final Settings settings;
    private final Set<String> databases;
    private final Map<String, String> messages;
    private final Language language;
    private final String languageCode;
    private final boolean rightToLeft;
    private final String suggestedOpenMSXPath;
    private final Component mainWindow;
    private JTextField openMSXFullPathTextField;
    private JButton openMSXFullPathBrowseButton;
    private JButton openMSXFullPathDetectButton;
    private JTextField screenshotsFullPathTextField;
    private JButton screenshotsFullPathBrowseButton;
    private JComboBox<String> defaultDatabaseComboBox;
    private JComboBoxWithImages languageComboBox;
    private JCheckBox enableFeedServiceCheckBox;
    private JButton okButton;
    private JButton cancelButton;

    public SettingsWindow(SettingsPresenter presenter, Settings settings, Set<String> databases, Language language, String languageCode, boolean rightToLeft, String suggestedOpenMSXPath) {
        this.presenter = presenter;
        this.settings = settings;
        this.databases = databases;
        this.mainWindow = GlobalSwingContext.getIntance().getMainWindow();
        this.messages = LanguageDisplayFactory.getDisplayMessages(this.getClass(), language);
        this.language = language;
        this.languageCode = languageCode;
        this.rightToLeft = rightToLeft;
        this.suggestedOpenMSXPath = suggestedOpenMSXPath;
    }

    public void display() {
        this.setDefaultCloseOperation(2);
        this.setTitle(this.messages.get("SETTINGS"));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(contentPane);
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JLabel openMSXFullPathLabel = new JLabel("openMSX");
        JLabel screenshotsFullPathLabel = new JLabel(this.messages.get("SCREENSHOTS"));
        JLabel defaultDatabaseLabel = new JLabel(this.messages.get("DATABASE"));
        JLabel languageLabel = new JLabel(this.messages.get("LANGUAGE"));
        if (this.rightToLeft) {
            openMSXFullPathLabel.setHorizontalAlignment(10);
            screenshotsFullPathLabel.setHorizontalAlignment(10);
            defaultDatabaseLabel.setHorizontalAlignment(10);
            languageLabel.setHorizontalAlignment(10);
        } else {
            openMSXFullPathLabel.setHorizontalAlignment(11);
            screenshotsFullPathLabel.setHorizontalAlignment(11);
            defaultDatabaseLabel.setHorizontalAlignment(11);
            languageLabel.setHorizontalAlignment(11);
        }
        this.openMSXFullPathTextField = new JTextField(this.settings.getOpenMSXFullPath());
        this.openMSXFullPathTextField.setColumns(10);
        this.openMSXFullPathBrowseButton = new JButton(Icons.FOLDER.getImageIcon());
        this.openMSXFullPathBrowseButton.addActionListener(this);
        this.openMSXFullPathBrowseButton.setToolTipText(this.messages.get("BROWSE"));
        this.openMSXFullPathDetectButton = new JButton(Icons.DETECT.getImageIcon());
        this.openMSXFullPathDetectButton.addActionListener(this);
        this.openMSXFullPathDetectButton.setToolTipText(this.messages.get("DETECT"));
        this.screenshotsFullPathTextField = new JTextField(this.settings.getScreenshotsFullPath());
        this.screenshotsFullPathTextField.setColumns(10);
        this.screenshotsFullPathBrowseButton = new JButton(Icons.FOLDER.getImageIcon());
        this.screenshotsFullPathBrowseButton.setToolTipText(this.messages.get("BROWSE"));
        this.screenshotsFullPathBrowseButton.addActionListener(this);
        this.defaultDatabaseComboBox = new JComboBox<String>(Utils.getSortedCaseInsensitiveArray(this.databases));
        this.defaultDatabaseComboBox.setSelectedItem(this.settings.getDefaultDatabase());
        Language[] languages = Language.values();
        List<Object> languagesAndIcons = new ArrayList<LanguageAndIcon>(languages.length + 1);
        for (int ix = 0; ix < languages.length; ++ix) {
            languagesAndIcons.add(new LanguageAndIcon(languages[ix].toString(), this.messages.get(languages[ix].toString()), Icons.valueOf("FLAG_" + languages[ix].getLocaleName()).getImageIcon()));
        }
        Collator collator = Collator.getInstance(Locale.forLanguageTag(this.language.getLocaleName()));
        languagesAndIcons = languagesAndIcons.stream().sorted((l1, l2) -> collator.compare(((LanguageAndIcon)l1).language, ((LanguageAndIcon)l2).language)).collect(Collectors.toList());
        languagesAndIcons.add(0, new LanguageAndIcon(null, this.messages.get("SYSTEM_DEFAULT"), null));
        this.languageComboBox = new JComboBoxWithImages((String[])languagesAndIcons.stream().map(li -> ((LanguageAndIcon)li).languageCode).toArray(String[]::new), (String[])languagesAndIcons.stream().map(li -> ((LanguageAndIcon)li).language).toArray(String[]::new), (ImageIcon[])languagesAndIcons.stream().map(li -> ((LanguageAndIcon)li).icon).toArray(ImageIcon[]::new), this.rightToLeft);
        this.languageComboBox.setMaximumRowCount(languages.length + 1);
        this.languageComboBox.setSelectedItem(this.messages.get(this.languageCode));
        this.enableFeedServiceCheckBox = new JCheckBox(this.messages.get("ENABLE_MSX_NEWS_SERVICE"));
        this.enableFeedServiceCheckBox.setSelected(this.settings.isEnableFeedService());
        JPanel fullPathPanel = new JPanel();
        fullPathPanel.setBorder(BorderFactory.createTitledBorder(this.messages.get("DIRECTORIES")));
        JPanel generalPanel = new JPanel();
        generalPanel.setBorder(BorderFactory.createTitledBorder(this.messages.get("GENERAL")));
        if (this.rightToLeft) {
            fullPathPanel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            generalPanel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.enableFeedServiceCheckBox.setHorizontalTextPosition(10);
        }
        JPanel groupPane = new JPanel();
        GroupLayout groupLayout = new GroupLayout(groupPane);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(11).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(130).addComponent(this.openMSXFullPathTextField, -2, 278, -2)).addGroup(groupLayout.createSequentialGroup().addGap(410).addComponent(false, this.openMSXFullPathBrowseButton, -2, 35, -2)).addGroup(groupLayout.createSequentialGroup().addGap(445).addComponent(false, this.openMSXFullPathDetectButton, -2, 35, -2)).addComponent(openMSXFullPathLabel, -2, 124, -2).addGroup(groupLayout.createSequentialGroup().addGap(130).addComponent(this.screenshotsFullPathTextField, -2, 278, -2)).addGroup(groupLayout.createSequentialGroup().addGap(410).addComponent(false, this.screenshotsFullPathBrowseButton, -2, 35, -2)).addComponent(screenshotsFullPathLabel, -2, 124, -2).addComponent(fullPathPanel, -2, 500, -2)).addGap(20)).addGroup(groupLayout.createSequentialGroup().addGap(11).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(languageLabel, -2, 124, -2).addGap(12).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.defaultDatabaseComboBox, -2, 200, -2).addComponent(this.languageComboBox, -2, 200, -2))).addComponent(defaultDatabaseLabel, -2, 124, -2).addGroup(groupLayout.createSequentialGroup().addGap(111).addComponent(this.enableFeedServiceCheckBox, -2, -2, -2)).addComponent(generalPanel, -2, 500, -2))).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(groupLayout.createSequentialGroup())));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(11).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(29).addComponent(this.openMSXFullPathTextField, -2, -1, -2)).addGroup(groupLayout.createSequentialGroup().addGap(29).addComponent(false, this.openMSXFullPathBrowseButton, -2, 26, -2)).addGroup(groupLayout.createSequentialGroup().addGap(29).addComponent(false, this.openMSXFullPathDetectButton, -2, 26, -2)).addGroup(groupLayout.createSequentialGroup().addGap(32).addComponent(openMSXFullPathLabel)).addGroup(groupLayout.createSequentialGroup().addGap(72).addComponent(this.screenshotsFullPathTextField, -2, -1, -2)).addGroup(groupLayout.createSequentialGroup().addGap(72).addComponent(false, this.screenshotsFullPathBrowseButton, -2, 26, -2)).addGroup(groupLayout.createSequentialGroup().addGap(75).addComponent(screenshotsFullPathLabel)).addComponent(fullPathPanel, -2, 115, -2)).addGap(14).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(70).addComponent(languageLabel)).addGroup(groupLayout.createSequentialGroup().addGap(28).addComponent(this.defaultDatabaseComboBox, -2, -1, -2).addGap(14).addComponent(this.languageComboBox, -2, -1, -2).addGap(16).addComponent(this.enableFeedServiceCheckBox, -2, -1, -2)).addGroup(groupLayout.createSequentialGroup().addGap(32).addComponent(defaultDatabaseLabel)).addComponent(generalPanel, -2, 146, -2))));
        groupPane.setLayout(groupLayout);
        contentPane.add(groupPane);
        JPanel buttonsPane = new JPanel();
        buttonsPane.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = new JButton(this.messages.get("OK"));
        this.okButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(this.messages.get("CANCEL"));
        this.cancelButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        this.cancelButton.addActionListener(this);
        buttonsPane.add(this.okButton);
        buttonsPane.add(this.cancelButton);
        contentPane.add(buttonsPane);
        if (this.rightToLeft) {
            groupPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            buttonsPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        this.pack();
        this.setLocationRelativeTo(this.mainWindow);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            String defaultDatabase = null;
            if (this.defaultDatabaseComboBox.getSelectedItem() != null) {
                defaultDatabase = this.defaultDatabaseComboBox.getSelectedItem().toString();
            }
            try {
                this.presenter.onRequestSettingsAction(this.openMSXFullPathTextField.getText(), this.screenshotsFullPathTextField.getText(), defaultDatabase, this.languageComboBox.getSelectedCode(), this.settings.isShowUpdateAllDatabases(), this.enableFeedServiceCheckBox.isSelected());
                this.dispose();
            }
            catch (LauncherException le) {
                MessageBoxUtil.showErrorMessageBox((Component)this, le, this.messages, this.rightToLeft);
            }
        } else if (source == this.cancelButton) {
            this.dispose();
        } else if (source == this.openMSXFullPathBrowseButton) {
            WindowUtils.browseForDirectory(this, this.openMSXFullPathTextField);
        } else if (source == this.openMSXFullPathDetectButton) {
            this.openMSXFullPathTextField.setText(this.suggestedOpenMSXPath);
        } else if (source == this.screenshotsFullPathBrowseButton) {
            WindowUtils.browseForDirectory(this, this.screenshotsFullPathTextField);
        }
    }

    private class LanguageAndIcon {
        private final String languageCode;
        private final String language;
        private final ImageIcon icon;

        LanguageAndIcon(String languageCode, String language, ImageIcon icon) {
            this.languageCode = languageCode;
            this.language = language;
            this.icon = icon;
        }
    }
}

