/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing.component;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public abstract class AbstractActionButton
extends JComponent {
    private final Color normalColor;
    private final Color hoverColor;
    private final Color pressedColor;
    protected boolean inside = false;
    private boolean pressed = false;

    public AbstractActionButton(final ActionListener listener, Color normalColor, Color hoverColor, Color pressedColor) {
        this.normalColor = normalColor;
        this.hoverColor = hoverColor;
        this.pressedColor = pressedColor;
        final AbstractActionButton actionButtonRef = this;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (AbstractActionButton.this.isEnabled()) {
                    listener.actionPerformed(new ActionEvent(actionButtonRef, 0, null));
                }
            }

            @Override
            public void mousePressed(MouseEvent me) {
                AbstractActionButton.this.pressed = true;
                AbstractActionButton.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                AbstractActionButton.this.pressed = false;
                AbstractActionButton.this.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent me) {
                AbstractActionButton.this.inside = true;
                AbstractActionButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent me) {
                AbstractActionButton.this.inside = false;
                AbstractActionButton.this.repaint();
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        if (this.inside) {
            if (this.isEnabled()) {
                if (this.pressed) {
                    g.setColor(this.pressedColor);
                } else {
                    g.setColor(this.hoverColor);
                }
            } else {
                g.setColor(this.normalColor);
            }
        } else {
            g.setColor(this.normalColor);
        }
        this.drawButton(g);
    }

    protected abstract void drawButton(Graphics var1);
}

