/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class JComboBoxWithImages
extends JComboBox<String> {
    private final String[] stringCodes;
    private final ImageIcon[] images;
    private final boolean rightToLeft;
    private final Border margin;
    private Map<String, Integer> codeToIndex = new HashMap<String, Integer>();

    public JComboBoxWithImages(String[] stringCodes, String[] localizedStrings, ImageIcon[] images, boolean rightToLeft) {
        super(localizedStrings);
        this.stringCodes = stringCodes;
        this.images = images;
        this.rightToLeft = rightToLeft;
        this.margin = rightToLeft ? new EmptyBorder(2, 0, 2, 4) : new EmptyBorder(2, 4, 2, 0);
        for (int ix = 0; ix < stringCodes.length; ++ix) {
            this.codeToIndex.put(localizedStrings[ix], ix);
        }
        this.setRenderer(new ComboBoxRenderer());
    }

    public String getSelectedCode() {
        return this.stringCodes[this.getSelectedIndex()];
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer<String> {
        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setBorder(JComboBoxWithImages.this.margin);
            if (JComboBoxWithImages.this.rightToLeft) {
                this.setHorizontalAlignment(4);
                this.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(Color.WHITE);
                this.setForeground(list.getForeground());
            }
            if (!JComboBoxWithImages.this.rightToLeft) {
                this.setText(value);
            }
            if (index > -1) {
                this.setIcon(JComboBoxWithImages.this.images[index]);
            } else {
                this.setIcon(JComboBoxWithImages.this.images[(Integer)JComboBoxWithImages.this.codeToIndex.get(value)]);
            }
            if (JComboBoxWithImages.this.rightToLeft) {
                this.setText(value);
            }
            return this;
        }
    }
}

