/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing.component;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.Timer;

public class JLabelTransitionedEnabledDisabledImage
extends JLabel {
    private static final int DELTA_TIME = 10;
    private static final int ELAPSED_TIME = 200;
    private static final int MAX_COUNT = 20;
    private static final float MAX_ALPHA = 1.0f;
    private static final float MIN_ALPHA = 0.2f;
    private Image image;
    private Timer timer;
    private float alpha;
    private boolean enabledFlag;

    public JLabelTransitionedEnabledDisabledImage(Icon icon) {
        super(icon);
        this.image = this.convertIconToImage(icon);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.enabledFlag) {
            this.enabledFlag = enabled;
            if (this.timer != null) {
                this.stopTransition();
            }
            this.timer = new Timer(10, new TransitionListener());
            this.timer.start();
        } else {
            this.showFinalState();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setComposite(((AlphaComposite)g2.getComposite()).derive(this.alpha));
        g2.drawImage(this.image, 0, 0, this);
        g2.dispose();
    }

    private Image convertIconToImage(Icon icon) {
        return ((ImageIcon)icon).getImage();
    }

    private void stopTransition() {
        this.timer.stop();
    }

    private void showFinalState() {
        this.alpha = this.enabledFlag ? 1.0f : 0.2f;
        this.repaint();
    }

    private class TransitionListener
    implements ActionListener {
        private int counter = 0;

        private TransitionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this.counter >= 20) {
                JLabelTransitionedEnabledDisabledImage.this.stopTransition();
            } else {
                if (JLabelTransitionedEnabledDisabledImage.this.enabledFlag) {
                    JLabelTransitionedEnabledDisabledImage.this.alpha = (float)this.counter / 20.0f * 0.8f + 0.2f;
                } else {
                    JLabelTransitionedEnabledDisabledImage.this.alpha = (20.0f - (float)this.counter) / 20.0f * 0.8f + 0.2f;
                }
                JLabelTransitionedEnabledDisabledImage.this.repaint();
                ++this.counter;
            }
        }
    }
}

