/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing.component;

import info.msxlaunchers.openmsx.launcher.ui.view.swing.MainWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class JTableButtonColumn
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor,
ActionListener,
MouseListener,
MouseMotionListener {
    private final JTable table;
    private final Action action;
    private final JButton renderButton;
    private final JButton actionButton;
    private Object editorValue;
    private boolean isButtonColumnEditor;
    private int currentRow;
    private int currentColumn;

    public JTableButtonColumn(JTable table, Action action, int column, Icon icon, String tooltipText) {
        this.table = table;
        this.action = action;
        this.renderButton = new JButton();
        this.renderButton.setContentAreaFilled(false);
        this.renderButton.addMouseListener(this);
        this.renderButton.setIcon(icon);
        this.renderButton.setToolTipText(tooltipText);
        this.actionButton = new JButton();
        this.actionButton.setContentAreaFilled(false);
        this.actionButton.setBorder(BorderFactory.createEtchedBorder());
        this.actionButton.setIcon(icon);
        this.actionButton.addActionListener(this);
        TableColumnModel columnModel = table.getColumnModel();
        columnModel.getColumn(column).setCellRenderer(this);
        columnModel.getColumn(column).setCellEditor(this);
        table.addMouseListener(this);
        table.addMouseMotionListener(this);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.editorValue = value;
        return this.actionButton;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editorValue;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (row == this.currentRow && column == this.currentColumn) {
            this.renderButton.setBackground(MainWindow.POPUP_MENU_ITEM_BUTTON_HOVER_BG_COLOR);
            this.renderButton.setBorder(BorderFactory.createEtchedBorder());
        } else {
            this.renderButton.setBackground(Color.white);
            this.renderButton.setBorder(null);
        }
        return this.renderButton;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int row = this.table.convertRowIndexToModel(this.table.getEditingRow());
        this.fireEditingStopped();
        this.action.actionPerformed(new ActionEvent(this.table, 1001, "" + row));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.table.isEditing() && this.table.getCellEditor() == this) {
            this.isButtonColumnEditor = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isButtonColumnEditor && this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        this.isButtonColumnEditor = false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.currentColumn = 0;
        this.currentRow = 0;
        this.table.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        if (p != null) {
            this.currentRow = this.table.rowAtPoint(p);
            this.currentColumn = this.table.columnAtPoint(p);
            this.table.repaint();
        }
    }
}

