/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.updater;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import info.msxlaunchers.openmsx.launcher.updater.FileUpdateFailedException;
import info.msxlaunchers.openmsx.launcher.updater.LauncherUpdater;
import info.msxlaunchers.openmsx.launcher.updater.UpdateChecker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

@Singleton
final class UpdateCheckerImpl
implements UpdateChecker {
    private final String jarFilesDirectory;
    private final String executableDirectory;
    private final String extraDataDirectory;
    private final String helpFileDirectory;
    private final LauncherUpdater launcherUpdater;
    private final String UPDATED_JAR_FILENAME = "new-launcher.zip";
    private final int WRITE_BUFFER = 2048;
    private final String MAIN_URL = "http://msxlaunchers.info/openmsx-launcher";
    private final String VERSIONS_RESOURCE = "/versions";
    private final String NEW_LAUNCHER_RESOURCE = "/new/launcher";
    private final String NEW_EXTRADATA_RESOURCE = "/new/extra-data";
    private final String NEW_DSK_XML_DB_RESOURCE = "/new/dsk-xml-db";
    private final String NEW_CAS_WAV_XML_DB_RESOURCE = "/new/caswav-xml-db";
    private boolean isDownloadedNewOpenLauncher = false;

    @Inject
    UpdateCheckerImpl(@Named(value="JarFilesDirectory") String jarFilesDirectory, @Named(value="LauncherDataDirectory") String executableDirectory, @Named(value="LauncherDataDirectory") String extraDataDirectory, LauncherUpdater launcherUpdater) {
        this.jarFilesDirectory = jarFilesDirectory;
        this.executableDirectory = executableDirectory;
        this.extraDataDirectory = extraDataDirectory;
        this.helpFileDirectory = extraDataDirectory;
        this.launcherUpdater = launcherUpdater;
    }

    @Override
    public Map<String, String> getVersions() throws IOException {
        HashMap<String, String> versions = new HashMap<String, String>();
        HttpURLConnection conn = this.getWebServiceConnection("http://msxlaunchers.info/openmsx-launcher/versions");
        try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            boolean done = false;
            while (!done) {
                String apiOutput = br.readLine();
                if (apiOutput == null) {
                    done = true;
                    continue;
                }
                int index = apiOutput.indexOf(61);
                String key = apiOutput.substring(0, index);
                String value = apiOutput.substring(index + 1);
                versions.put(key, value);
            }
            conn.disconnect();
        }
        return versions;
    }

    @Override
    public void getNewOpenMSXLauncher() throws FileUpdateFailedException, IOException {
        HttpURLConnection conn = this.getWebServiceConnection("http://msxlaunchers.info/openmsx-launcher/new/launcher");
        File zipFile = new File(this.jarFilesDirectory, "new-launcher.zip");
        this.writeDownloadedFile(conn, zipFile);
        this.launcherUpdater.installNewOpenMSXLauncher(this.jarFilesDirectory, this.executableDirectory, this.helpFileDirectory, zipFile);
        this.isDownloadedNewOpenLauncher = true;
    }

    @Override
    public boolean isNewOpenMSXLauncherDownloaded() {
        return this.isDownloadedNewOpenLauncher;
    }

    @Override
    public void getNewExtraDataFile() throws IOException {
        HttpURLConnection conn = this.getWebServiceConnection("http://msxlaunchers.info/openmsx-launcher/new/extra-data");
        this.writeDownloadedFile(conn, new File(this.extraDataDirectory, "extra-data.dat"));
        conn = this.getWebServiceConnection("http://msxlaunchers.info/openmsx-launcher/new/dsk-xml-db");
        this.writeDownloadedFile(conn, new File(this.extraDataDirectory, "msxdskdb.xml"));
        conn = this.getWebServiceConnection("http://msxlaunchers.info/openmsx-launcher/new/caswav-xml-db");
        this.writeDownloadedFile(conn, new File(this.extraDataDirectory, "msxcaswavdb.xml"));
    }

    private HttpURLConnection getWebServiceConnection(String urlString) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        if (conn.getResponseCode() != 200) {
            throw new IOException();
        }
        return conn;
    }

    private void writeDownloadedFile(HttpURLConnection conn, File file) throws IOException {
        try (InputStream in = conn.getInputStream();
             FileOutputStream out = new FileOutputStream(file);){
            byte[] buf = new byte[2048];
            int n = in.read(buf);
            while (n >= 0) {
                out.write(buf, 0, n);
                n = in.read(buf);
            }
            out.flush();
        }
        conn.disconnect();
    }
}

