/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.platform;

import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.platform.ArgumentsBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class UnixFamilyArgumentsBuilder
implements ArgumentsBuilder {
    private List<String> argsList;
    private StringBuilder builder;

    UnixFamilyArgumentsBuilder() {
        this.initialize();
    }

    @Override
    public void append(String argument) {
        Objects.requireNonNull(argument);
        this.builder.append(" ").append(argument);
    }

    @Override
    public void appendIfValueDefined(String cmdLineSwitch, String value) {
        Objects.requireNonNull(cmdLineSwitch);
        if (!Utils.isEmpty(value)) {
            this.builder.append(" ").append(cmdLineSwitch).append(" \"" + value + "\"");
        }
    }

    @Override
    public List<String> getArgumentList() {
        this.argsList.add(this.builder.toString());
        ArrayList<String> argsListCopy = new ArrayList<String>(this.argsList);
        this.initialize();
        return Collections.unmodifiableList(argsListCopy);
    }

    private void initialize() {
        this.argsList = new ArrayList<String>(3);
        this.builder = new StringBuilder();
        this.argsList.add("bash");
        this.argsList.add("-c");
    }
}

