/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.game.repository;

import com.google.inject.Inject;
import info.msxlaunchers.openmsx.game.repository.RepositoryData;
import info.msxlaunchers.openmsx.game.repository.XMLFileGetter;
import info.msxlaunchers.openmsx.game.repository.processor.XMLProcessor;
import info.msxlaunchers.openmsx.launcher.data.repository.RepositoryGame;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class XMLRepositoryData
implements RepositoryData {
    private final XMLProcessor xmlProcessor;
    private final Set<XMLFileGetter> xmlFileGetters;

    @Inject
    XMLRepositoryData(XMLProcessor xmlProcessor, Set<XMLFileGetter> xmlFileGetters) {
        this.xmlProcessor = Objects.requireNonNull(xmlProcessor);
        this.xmlFileGetters = Objects.requireNonNull(xmlFileGetters);
    }

    @Override
    public Map<String, RepositoryGame> getRepositoryInfo() throws IOException {
        HashMap<String, RepositoryGame> repositoryInfo = null;
        for (XMLFileGetter xmlFileGetter : this.xmlFileGetters) {
            File xmlFile = xmlFileGetter.get();
            if (xmlFile == null || !xmlFile.exists()) continue;
            if (repositoryInfo == null) {
                repositoryInfo = new HashMap<String, RepositoryGame>();
            }
            repositoryInfo.putAll(this.xmlProcessor.getRepositoryInfo(xmlFile));
        }
        return repositoryInfo;
    }

    @Override
    public Set<String> getDumpCodes(String code) throws IOException {
        Objects.requireNonNull(code);
        for (XMLFileGetter xmlFileGetter : this.xmlFileGetters) {
            Set<String> dumpCodes = this.xmlProcessor.getDumpCodes(xmlFileGetter.get(), code);
            if (dumpCodes.isEmpty()) continue;
            return dumpCodes;
        }
        return Collections.emptySet();
    }

    @Override
    public RepositoryGame getGameInfo(String code) throws IOException {
        Objects.requireNonNull(code);
        for (XMLFileGetter xmlFileGetter : this.xmlFileGetters) {
            RepositoryGame repositoryGame = this.xmlProcessor.getGameInfo(xmlFileGetter.get(), code);
            if (repositoryGame == null) continue;
            return repositoryGame;
        }
        return null;
    }
}

