/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.game.repository.processor;

import info.msxlaunchers.openmsx.game.repository.processor.AllDumpCodesParseHandler;
import info.msxlaunchers.openmsx.game.repository.processor.GameInfoParseHandler;
import info.msxlaunchers.openmsx.game.repository.processor.RepositoryInfoParseHandler;
import info.msxlaunchers.openmsx.game.repository.processor.StopSAXParsingException;
import info.msxlaunchers.openmsx.game.repository.processor.XMLProcessor;
import info.msxlaunchers.openmsx.launcher.data.repository.RepositoryGame;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

final class SAXXMLProcessor
implements XMLProcessor {
    SAXXMLProcessor() {
    }

    @Override
    public Map<String, RepositoryGame> getRepositoryInfo(File xmlFile) throws IOException {
        RepositoryInfoParseHandler handler = new RepositoryInfoParseHandler();
        SAXXMLProcessor.parse(xmlFile, handler);
        return handler.getRepositoryInfo();
    }

    @Override
    public Set<String> getDumpCodes(File xmlFile, String code) throws IOException {
        AllDumpCodesParseHandler handler = new AllDumpCodesParseHandler(code);
        SAXXMLProcessor.parse(xmlFile, handler);
        return handler.getAllDumpCodes();
    }

    @Override
    public RepositoryGame getGameInfo(File xmlFile, String code) throws IOException {
        GameInfoParseHandler handler = new GameInfoParseHandler(code);
        SAXXMLProcessor.parse(xmlFile, handler);
        return handler.getGameInfo();
    }

    private static void parse(File xmlFile, DefaultHandler handler) throws IOException {
        SAXParserFactory spfac = SAXParserFactory.newInstance();
        try {
            spfac.setFeature("http://apache.org/xml/features/validation/schema", false);
            spfac.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
        try (FileInputStream inputStream2 = new FileInputStream(xmlFile);){
            SAXParser parser = spfac.newSAXParser();
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream2, "UTF-8");
            InputSource is = new InputSource(reader);
            is.setEncoding("UTF-8");
            parser.parse(is, handler);
        }
        catch (StopSAXParsingException inputStream2) {
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException();
        }
    }
}

