/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.game.scan;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import info.msxlaunchers.openmsx.common.FileTypeUtils;
import info.msxlaunchers.openmsx.common.FileUtils;
import info.msxlaunchers.openmsx.common.HashUtils;
import info.msxlaunchers.openmsx.common.Nullable;
import info.msxlaunchers.openmsx.game.repository.RepositoryData;
import info.msxlaunchers.openmsx.game.scan.Scanner;
import info.msxlaunchers.openmsx.launcher.builder.GameBuilder;
import info.msxlaunchers.openmsx.launcher.data.extra.ExtraData;
import info.msxlaunchers.openmsx.launcher.data.game.Game;
import info.msxlaunchers.openmsx.launcher.data.repository.RepositoryGame;
import info.msxlaunchers.openmsx.launcher.extra.ExtraDataGetter;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersister;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

final class FileScanner
implements Scanner {
    private final GamePersister gamePersister;
    private final RepositoryData repositoryData;
    private boolean interrupted;
    private Set<Game> processedGames = null;
    private Set<String> processedGameNames = null;
    private Set<String> processedGameSha1Codes = null;
    private Map<String, RepositoryGame> sha1ToRepositoryGameMap = null;
    private final GameBuilder gameBuilder;
    private final ExtraDataGetter extraDataGetter;
    private final String baseDirectory;
    private boolean traverseSubDirectories;
    private String machine = null;
    private boolean searchROM = false;
    private boolean searchDisk = false;
    private boolean searchTape = false;
    private boolean searchLaserdisc = false;
    private boolean getNameFromOpenMSXDatabase;
    private Map<String, ExtraData> extraDataMap;
    private final String NAME_COLLISION_SEPARATOR = "__";
    private final String EXTENSION_ROM_IDE = "ide";

    @Inject
    FileScanner(GamePersister gamePersister, RepositoryData repositoryData, GameBuilder gameBuilder, ExtraDataGetter extraDataGetter, @Nullable @Named(value="BaseDirectory") String baseDirectory) {
        this.gamePersister = Objects.requireNonNull(gamePersister);
        this.repositoryData = Objects.requireNonNull(repositoryData);
        this.gameBuilder = Objects.requireNonNull(gameBuilder);
        this.extraDataGetter = Objects.requireNonNull(extraDataGetter);
        this.baseDirectory = baseDirectory;
        this.interrupted = false;
    }

    @Override
    public int scan(String[] paths, boolean traverseSubDirectories, String database, boolean newDatabase, boolean append, String machine, boolean searchROM, boolean searchDisk, boolean searchTape, boolean searchLaserdisc, boolean getNameFromOpenMSXDatabase, boolean backupDatabase) throws GamePersistenceException, IOException {
        this.interrupted = false;
        this.traverseSubDirectories = traverseSubDirectories;
        this.machine = machine;
        this.searchROM = searchROM;
        this.searchDisk = searchDisk;
        this.searchTape = searchTape;
        this.searchLaserdisc = searchLaserdisc;
        this.getNameFromOpenMSXDatabase = getNameFromOpenMSXDatabase;
        this.extraDataMap = this.extraDataGetter.getExtraData();
        this.processedGames = new HashSet<Game>();
        this.processedGameNames = new HashSet<String>();
        this.processedGameSha1Codes = new HashSet<String>();
        if (newDatabase) {
            this.gamePersister.createDatabase(database);
        } else {
            if (backupDatabase) {
                this.gamePersister.backupDatabase(database);
            }
            if (!append) {
                this.gamePersister.recreateDatabase(database);
            }
            Set<Game> savedGames = this.gamePersister.getGames(database);
            for (Game processedGame : savedGames) {
                this.processedGameNames.add(processedGame.getName());
                this.processedGameSha1Codes.add(processedGame.getSha1Code());
            }
        }
        if (getNameFromOpenMSXDatabase) {
            this.sha1ToRepositoryGameMap = this.repositoryData.getRepositoryInfo();
        }
        int totalFound = 0;
        for (String path : paths) {
            if (this.interrupted) break;
            totalFound += this.traverse(new File(path), this.getAbsolutePath(path, this.baseDirectory), true);
        }
        try {
            this.gamePersister.saveGames(this.processedGames, database);
        }
        catch (GamePersistenceException gamePersistenceException) {
            // empty catch block
        }
        return totalFound;
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
    }

    private int traverse(File relativePath, File absolutePath, boolean firstCall) {
        File[] fileList;
        int totalFound = 0;
        if (absolutePath.isFile()) {
            totalFound += this.processFile(absolutePath, relativePath.getParentFile());
        } else if ((this.traverseSubDirectories || firstCall) && (fileList = absolutePath.listFiles()) != null) {
            for (File file : fileList) {
                totalFound += this.traverse(new File(relativePath, file.getName()), file, false);
            }
        }
        return totalFound;
    }

    private File getAbsolutePath(String relativePath, String baseDirectory) {
        if (baseDirectory == null) {
            return new File(relativePath);
        }
        return new File(new File(baseDirectory), relativePath);
    }

    private String getRealFullFilePath(File file, File relativePath) {
        return new File(relativePath, file.getName()).getAbsolutePath();
    }

    private int processFile(File file, File relativePath) {
        int added = 0;
        if (FileTypeUtils.isROM(file) || FileTypeUtils.isDisk(file) || FileTypeUtils.isTape(file) || FileTypeUtils.isHarddisk(file) || FileTypeUtils.isLaserdisc(file)) {
            String sha1Code = HashUtils.getSHA1Code(file);
            added = this.processPotentialGame(file, this.getRealFullFilePath(file, relativePath), file.length(), sha1Code);
        } else if (FileTypeUtils.isZIP(file)) {
            added = this.processZipFile(file, relativePath);
        }
        return added;
    }

    private int processPotentialGame(File file, String fileNameToUse, long fileSize, String sha1Code) {
        int added = 0;
        if (file != null) {
            if (this.searchROM && FileTypeUtils.isROM(file)) {
                added = this.addToProcessedGames(this.getGameName(file, sha1Code), fileNameToUse, null, null, null, null, null, sha1Code, fileSize);
            } else if (this.searchDisk && FileTypeUtils.isDisk(file)) {
                added = fileSize <= 737280L ? this.addToProcessedGames(this.getGameName(file, sha1Code), null, fileNameToUse, null, null, null, null, sha1Code, fileSize) : this.addToProcessedGames(this.getGameName(file, sha1Code), null, null, fileNameToUse, "ide", null, null, sha1Code, fileSize);
            } else if (this.searchTape && FileTypeUtils.isTape(file)) {
                added = this.addToProcessedGames(this.getGameName(file, sha1Code), null, null, null, null, fileNameToUse, null, sha1Code, fileSize);
            } else if (this.searchDisk && FileTypeUtils.isHarddisk(file)) {
                added = this.addToProcessedGames(this.getGameName(file, sha1Code), null, null, fileNameToUse, "ide", null, null, sha1Code, fileSize);
            } else if (this.searchLaserdisc && FileTypeUtils.isLaserdisc(file)) {
                added = this.addToProcessedGames(this.getGameName(file, sha1Code), null, null, null, null, null, fileNameToUse, sha1Code, fileSize);
            }
        }
        return added;
    }

    private int processZipFile(File zipFile, File relativePath) {
        int added = 0;
        try (ZipFile zip = new ZipFile(zipFile);){
            ZipEntry firstZipEntry = zip.entries().nextElement();
            try (InputStream inputStream = zip.getInputStream(firstZipEntry);){
                String sha1Code = HashUtils.getSHA1Code(inputStream);
                added = this.processPotentialGame(new File(firstZipEntry.getName()), this.getRealFullFilePath(zipFile, relativePath), firstZipEntry.getSize(), sha1Code);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return added;
    }

    private int addToProcessedGames(String name, String rom, String disk, String harddisk, String extensionRom, String tape, String laserdisc, String sha1Code, long fileSize) {
        String adjustedName;
        Game game;
        int added = 0;
        if (!this.processedGameSha1Codes.contains(sha1Code) && (game = this.gameBuilder.createGameObjectForScannedFiles(adjustedName = this.adjustedNameIfNecessary(name), this.machine, rom, extensionRom, disk, tape, harddisk, laserdisc, sha1Code, fileSize, this.extraDataMap)) != null) {
            this.processedGames.add(game);
            this.processedGameNames.add(adjustedName);
            this.processedGameSha1Codes.add(sha1Code);
            added = 1;
        }
        return added;
    }

    private String adjustedNameIfNecessary(String name) {
        StringBuilder nameBuffer = new StringBuilder(name);
        int counter = 0;
        while (this.processedGameNames.contains(nameBuffer.toString())) {
            nameBuffer = new StringBuilder(name).append("__").append(++counter);
        }
        return nameBuffer.toString();
    }

    private String getGameName(File file, String sha1Code) {
        String name = null;
        if (this.getNameFromOpenMSXDatabase) {
            RepositoryGame repositoryGame = this.sha1ToRepositoryGameMap.get(sha1Code);
            if (repositoryGame != null) {
                name = repositoryGame.getTitle();
                if (name == null) {
                    name = FileUtils.getFileNameWithoutExtension(file);
                }
            } else {
                name = FileUtils.getFileNameWithoutExtension(file);
            }
        } else {
            name = FileUtils.getFileNameWithoutExtension(file);
        }
        return name;
    }
}

