/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.data.feed;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class FeedMessage {
    private final String title;
    private final String link;
    private final LocalDate pubDate;
    private final String feedSiteName;
    private final String feedSiteUrl;

    public FeedMessage(String title, String link, String pubDate, String feedSiteName, String feedSiteUrl) {
        this.title = title;
        this.link = link;
        this.pubDate = LocalDate.parse(pubDate, DateTimeFormatter.RFC_1123_DATE_TIME);
        this.feedSiteName = feedSiteName;
        this.feedSiteUrl = feedSiteUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public String getLink() {
        return this.link;
    }

    public LocalDate getPubDate() {
        return this.pubDate;
    }

    public String getPubDateDisplayName() {
        return this.getPaddedNumber(this.pubDate.getDayOfMonth()) + "-" + this.getPaddedNumber(this.pubDate.getMonthValue());
    }

    public String getFeedSiteName() {
        return this.feedSiteName;
    }

    public String getFeedSiteUrl() {
        return this.feedSiteUrl;
    }

    public String toString() {
        return "[title=" + this.title + ", link=" + this.link + ", pubDate=" + this.pubDate + ", feedSiteName=" + this.feedSiteName + ", feedSiteUrl=" + this.feedSiteUrl + "]";
    }

    private String getPaddedNumber(int number) {
        return number < 10 ? "0" + number : "" + number;
    }
}

