/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.data.filter;

import info.msxlaunchers.openmsx.launcher.data.filter.Filter;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterDescriptor;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterType;
import info.msxlaunchers.openmsx.launcher.data.filter.Value1Field;
import info.msxlaunchers.openmsx.launcher.data.game.Game;
import info.msxlaunchers.openmsx.launcher.data.game.constants.Medium;
import info.msxlaunchers.openmsx.launcher.data.repository.RepositoryGame;
import java.util.Objects;

@FilterDescriptor(type=FilterType.MEDIUM)
final class MediumFilter
implements Filter {
    @Value1Field
    private final Medium medium;

    MediumFilter(Medium medium) {
        this.medium = Objects.requireNonNull(medium);
    }

    public int hashCode() {
        return this.medium.hashCode();
    }

    public boolean equals(Object obj) {
        boolean isSame = obj == null || !(obj instanceof MediumFilter) ? false : this.medium.equals((Object)((MediumFilter)obj).medium);
        return isSame;
    }

    @Override
    public boolean isFiltered(Game game, RepositoryGame repositoryGame) {
        Objects.requireNonNull(game);
        boolean filtered = false;
        switch (this.medium) {
            case ROM: {
                filtered = !game.isROM();
                break;
            }
            case DISK: {
                filtered = !game.isDisk();
                break;
            }
            case TAPE: {
                filtered = !game.isTape();
                break;
            }
            case HARDDISK: {
                filtered = !game.isHarddisk();
                break;
            }
            case LASERDISC: {
                filtered = !game.isLaserdisc();
                break;
            }
            case SCRIPT: {
                filtered = !game.isScript();
                break;
            }
            default: {
                throw new RuntimeException("Update filter if Medium contains an extra medium");
            }
        }
        return filtered;
    }
}

