/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.data.filter;

import info.msxlaunchers.openmsx.launcher.data.filter.Filter;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterDescriptor;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterType;
import info.msxlaunchers.openmsx.launcher.data.filter.Value1Field;
import info.msxlaunchers.openmsx.launcher.data.game.Game;
import info.msxlaunchers.openmsx.launcher.data.game.constants.Sound;
import info.msxlaunchers.openmsx.launcher.data.repository.RepositoryGame;
import java.util.Objects;

@FilterDescriptor(type=FilterType.SOUND)
final class SoundFilter
implements Filter {
    @Value1Field
    private final Sound sound;

    SoundFilter(Sound sound) {
        this.sound = Objects.requireNonNull(sound);
    }

    public int hashCode() {
        return this.sound.hashCode();
    }

    public boolean equals(Object obj) {
        boolean isSame = obj == null || !(obj instanceof SoundFilter) ? false : this.sound.equals(((SoundFilter)obj).sound);
        return isSame;
    }

    @Override
    public boolean isFiltered(Game game, RepositoryGame repositoryGame) {
        Objects.requireNonNull(game);
        boolean filtered = false;
        switch (this.sound) {
            case PSG: {
                filtered = !game.isPSG();
                break;
            }
            case SCC: {
                filtered = !game.isSCC();
                break;
            }
            case SCC_I: {
                filtered = !game.isSCCI();
                break;
            }
            case PCM: {
                filtered = !game.isPCM();
                break;
            }
            case MSX_MUSIC: {
                filtered = !game.isMSXMUSIC();
                break;
            }
            case MSX_AUDIO: {
                filtered = !game.isMSXAUDIO();
                break;
            }
            case MOONSOUND: {
                filtered = !game.isMoonsound();
                break;
            }
            case MIDI: {
                filtered = !game.isMIDI();
                break;
            }
            default: {
                throw new RuntimeException("Update filter if Sound contains an extra sound chip");
            }
        }
        return filtered;
    }
}

