/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.data.game;

import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.openmsx.launcher.data.game.constants.FDDMode;
import info.msxlaunchers.openmsx.launcher.data.game.constants.Genre;
import info.msxlaunchers.openmsx.launcher.data.game.constants.InputDevice;
import java.io.Serializable;

public final class Game
implements Serializable {
    private static final long serialVersionUID = 6233080612490194173L;
    private final String name;
    private final String info;
    private final String machine;
    private final String romA;
    private final String romB;
    private final String extensionRom;
    private final String diskA;
    private final String diskB;
    private final String tape;
    private final String harddisk;
    private final String laserdisc;
    private final boolean isMSX;
    private final boolean isMSX2;
    private final boolean isMSX2Plus;
    private final boolean isTurboR;
    private final boolean isPSG;
    private final boolean isSCC;
    private final boolean isSCCI;
    private final boolean isPCM;
    private final boolean isMSXMUSIC;
    private final boolean isMSXAUDIO;
    private final boolean isMoonsound;
    private final boolean isMIDI;
    private final Genre genre1;
    private final Genre genre2;
    private final int msxGenID;
    private final String sha1Code;
    private final long size;
    private final String screenshotSuffix;
    private final String tclScript;
    private final boolean tclScriptOverride;
    private final FDDMode fddMode;
    private final InputDevice inputDevice;
    private final boolean connectGFX9000;

    public static GameParam machine(String machine) {
        return new GameParam().machine(machine);
    }

    public static GameParam romA(String romA) {
        return new GameParam().romA(romA);
    }

    public static GameParam romB(String romB) {
        return new GameParam().romB(romB);
    }

    public static GameParam extensionRom(String extensionRom) {
        return new GameParam().extensionRom(extensionRom);
    }

    public static GameParam diskA(String diskA) {
        return new GameParam().diskA(diskA);
    }

    public static GameParam diskB(String diskB) {
        return new GameParam().diskB(diskB);
    }

    public static GameParam tape(String tape) {
        return new GameParam().tape(tape);
    }

    public static GameParam harddisk(String harddisk) {
        return new GameParam().harddisk(harddisk);
    }

    public static GameParam laserdisc(String laserdisc) {
        return new GameParam().laserdisc(laserdisc);
    }

    public static GameParam name(String name) {
        return new GameParam().name(name);
    }

    public static GameParam info(String info) {
        return new GameParam().info(info);
    }

    public static GameParam isMSX(boolean isMSX) {
        return new GameParam().isMSX(isMSX);
    }

    public static GameParam isMSX2(boolean isMSX2) {
        return new GameParam().isMSX2(isMSX2);
    }

    public static GameParam isMSX2Plus(boolean isMSX2Plus) {
        return new GameParam().isMSX2Plus(isMSX2Plus);
    }

    public static GameParam isTurboR(boolean isTurboR) {
        return new GameParam().isTurboR(isTurboR);
    }

    public static GameParam isPSG(boolean isPSG) {
        return new GameParam().isPSG(isPSG);
    }

    public static GameParam isSCC(boolean isSCC) {
        return new GameParam().isSCC(isSCC);
    }

    public static GameParam isSCCI(boolean isSCCI) {
        return new GameParam().isSCCI(isSCCI);
    }

    public static GameParam isPCM(boolean isPCM) {
        return new GameParam().isPCM(isPCM);
    }

    public static GameParam isMSXMUSIC(boolean isMSXMUSIC) {
        return new GameParam().isMSXMUSIC(isMSXMUSIC);
    }

    public static GameParam isMSXAUDIO(boolean isMSXAUDIO) {
        return new GameParam().isMSXAUDIO(isMSXAUDIO);
    }

    public static GameParam isMoonsound(boolean isMoonsound) {
        return new GameParam().isMoonsound(isMoonsound);
    }

    public static GameParam isMIDI(boolean isMIDI) {
        return new GameParam().isMIDI(isMIDI);
    }

    public static GameParam genre1(Genre genre1) {
        return new GameParam().genre1(genre1);
    }

    public static GameParam genre2(Genre genre2) {
        return new GameParam().genre2(genre2);
    }

    public static GameParam msxGenID(int msxGenID) {
        return new GameParam().msxGenID(msxGenID);
    }

    public static GameParam sha1Code(String sha1Code) {
        return new GameParam().sha1Code(sha1Code);
    }

    public static GameParam size(long size) {
        return new GameParam().size(size);
    }

    public static GameParam screenshotSuffix(String screenshotSuffix) {
        return new GameParam().screenshotSuffix(screenshotSuffix);
    }

    public static GameParam tclScript(String tclScript) {
        return new GameParam().tclScript(tclScript);
    }

    public static GameParam tclScriptOverride(boolean tclScriptOverride) {
        return new GameParam().tclScriptOverride(tclScriptOverride);
    }

    public static GameParam fddMode(FDDMode fddMode) {
        return new GameParam().fddMode(fddMode);
    }

    public static GameParam inputDevice(InputDevice inputDevice) {
        return new GameParam().inputDevice(inputDevice);
    }

    public static GameParam connectGFX9000(boolean connectGFX9000) {
        return new GameParam().connectGFX9000(connectGFX9000);
    }

    private Game(GameParam param) {
        this.machine = param.machine;
        this.romA = param.romA;
        this.romB = param.romB;
        this.extensionRom = param.extensionRom;
        this.diskA = param.diskA;
        this.diskB = param.diskB;
        this.tape = param.tape;
        this.harddisk = param.harddisk;
        this.laserdisc = param.laserdisc;
        this.name = param.name;
        this.info = param.info;
        this.isMSX = param.isMSX;
        this.isMSX2 = param.isMSX2;
        this.isMSX2Plus = param.isMSX2Plus;
        this.isTurboR = param.isTurboR;
        this.isPSG = param.isPSG;
        this.isSCC = param.isSCC;
        this.isSCCI = param.isSCCI;
        this.isPCM = param.isPCM;
        this.isMSXMUSIC = param.isMSXMUSIC;
        this.isMSXAUDIO = param.isMSXAUDIO;
        this.isMoonsound = param.isMoonsound;
        this.isMIDI = param.isMIDI;
        this.genre1 = param.genre1;
        this.genre2 = param.genre2;
        this.msxGenID = param.msxGenID;
        this.sha1Code = param.sha1Code;
        this.size = param.size;
        this.screenshotSuffix = param.screenshotSuffix;
        this.tclScript = param.tclScript;
        this.tclScriptOverride = param.tclScriptOverride;
        this.fddMode = param.fddMode;
        this.inputDevice = param.inputDevice;
        this.connectGFX9000 = param.connectGFX9000;
    }

    public boolean equals(Object game) {
        boolean isSame = this.name == null || game == null || !(game instanceof Game) ? false : this.name.equals(((Game)game).getName());
        return isSame;
    }

    public int hashCode() {
        return this.name == null ? super.hashCode() : this.name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public String getMachine() {
        return this.machine;
    }

    public String getRomA() {
        return this.romA;
    }

    public String getRomB() {
        return this.romB;
    }

    public String getExtensionRom() {
        return this.extensionRom;
    }

    public String getDiskA() {
        return this.diskA;
    }

    public String getDiskB() {
        return this.diskB;
    }

    public String getTape() {
        return this.tape;
    }

    public String getInfo() {
        return this.info;
    }

    public String getHarddisk() {
        return this.harddisk;
    }

    public String getLaserdisc() {
        return this.laserdisc;
    }

    public boolean isMSX() {
        return this.isMSX;
    }

    public boolean isMSX2() {
        return this.isMSX2;
    }

    public boolean isMSX2Plus() {
        return this.isMSX2Plus;
    }

    public boolean isTurboR() {
        return this.isTurboR;
    }

    public boolean isPSG() {
        return this.isPSG;
    }

    public boolean isSCC() {
        return this.isSCC;
    }

    public boolean isSCCI() {
        return this.isSCCI;
    }

    public boolean isPCM() {
        return this.isPCM;
    }

    public boolean isMSXMUSIC() {
        return this.isMSXMUSIC;
    }

    public boolean isMSXAUDIO() {
        return this.isMSXAUDIO;
    }

    public boolean isMoonsound() {
        return this.isMoonsound;
    }

    public boolean isMIDI() {
        return this.isMIDI;
    }

    public Genre getGenre1() {
        return this.genre1;
    }

    public Genre getGenre2() {
        return this.genre2;
    }

    public int getMsxGenID() {
        return this.msxGenID;
    }

    public String getSha1Code() {
        return this.sha1Code;
    }

    public long getSize() {
        return this.size;
    }

    public String getScreenshotSuffix() {
        return this.screenshotSuffix;
    }

    public String getTclScript() {
        return this.tclScript;
    }

    public boolean isTclScriptOverride() {
        return this.tclScriptOverride;
    }

    public FDDMode getFDDMode() {
        return this.fddMode;
    }

    public InputDevice getInputDevice() {
        return this.inputDevice;
    }

    public boolean isConnectGFX9000() {
        return this.connectGFX9000;
    }

    public boolean isROM() {
        return this.romA != null;
    }

    public boolean isDisk() {
        return !this.isROM() && this.diskA != null;
    }

    public boolean isTape() {
        return !this.isDisk() && this.tape != null;
    }

    public boolean isHarddisk() {
        return !this.isTape() && this.harddisk != null;
    }

    public boolean isLaserdisc() {
        return !this.isHarddisk() && this.laserdisc != null;
    }

    public boolean isScript() {
        return !this.isLaserdisc() && this.tclScript != null;
    }

    public boolean isExtraDataEqual(Game game) {
        boolean isEqual = false;
        if (game != null) {
            isEqual = this.isMSX() == game.isMSX() && this.isMSX2() == game.isMSX2() && this.isMSX2Plus() == game.isMSX2Plus() && this.isTurboR() == game.isTurboR() && this.isPSG() == game.isPSG() && this.isSCC() == game.isSCC() && this.isSCCI() == game.isSCCI() && this.isPCM() == game.isPCM() && this.isMSXMUSIC() == game.isMSXMUSIC() && this.isMSXAUDIO() == game.isMSXAUDIO() && this.isMoonsound() == game.isMoonsound() && this.isMIDI() == game.isMIDI() && this.getGenre1() == game.getGenre1() && this.getGenre2() == game.getGenre2() && Utils.equalStrings(this.getScreenshotSuffix(), game.getScreenshotSuffix()) && this.getMsxGenID() == game.getMsxGenID();
        }
        return isEqual;
    }

    public static class GameParam {
        private String name;
        private String info;
        private String machine;
        private String romA;
        private String romB;
        private String extensionRom;
        private String diskA;
        private String diskB;
        private String tape;
        private String harddisk;
        private String laserdisc;
        private boolean isMSX;
        private boolean isMSX2;
        private boolean isMSX2Plus;
        private boolean isTurboR;
        private boolean isPSG;
        private boolean isSCC;
        private boolean isSCCI;
        private boolean isPCM;
        private boolean isMSXMUSIC;
        private boolean isMSXAUDIO;
        private boolean isMoonsound;
        private boolean isMIDI;
        private Genre genre1;
        private Genre genre2;
        private int msxGenID;
        private String sha1Code;
        private long size;
        private String screenshotSuffix;
        private String tclScript;
        private boolean tclScriptOverride;
        private FDDMode fddMode;
        private InputDevice inputDevice;
        private boolean connectGFX9000;

        public GameParam machine(String machine) {
            this.machine = Utils.resetIfEmpty(machine);
            return this;
        }

        public GameParam romA(String romA) {
            this.romA = Utils.resetIfEmpty(romA);
            return this;
        }

        public GameParam romB(String romB) {
            this.romB = Utils.resetIfEmpty(romB);
            return this;
        }

        public GameParam extensionRom(String extensionRom) {
            this.extensionRom = Utils.resetIfEmpty(extensionRom);
            return this;
        }

        public GameParam diskA(String diskA) {
            this.diskA = Utils.resetIfEmpty(diskA);
            return this;
        }

        public GameParam diskB(String diskB) {
            this.diskB = Utils.resetIfEmpty(diskB);
            return this;
        }

        public GameParam tape(String tape) {
            this.tape = Utils.resetIfEmpty(tape);
            return this;
        }

        public GameParam harddisk(String harddisk) {
            this.harddisk = Utils.resetIfEmpty(harddisk);
            return this;
        }

        public GameParam laserdisc(String laserdisc) {
            this.laserdisc = Utils.resetIfEmpty(laserdisc);
            return this;
        }

        public GameParam name(String name) {
            this.name = Utils.resetIfEmpty(name);
            return this;
        }

        public GameParam info(String info) {
            this.info = Utils.resetIfEmpty(info);
            return this;
        }

        public GameParam isMSX(boolean isMSX) {
            this.isMSX = isMSX;
            return this;
        }

        public GameParam isMSX2(boolean isMSX2) {
            this.isMSX2 = isMSX2;
            return this;
        }

        public GameParam isMSX2Plus(boolean isMSX2Plus) {
            this.isMSX2Plus = isMSX2Plus;
            return this;
        }

        public GameParam isTurboR(boolean isTurboR) {
            this.isTurboR = isTurboR;
            return this;
        }

        public GameParam isPSG(boolean isPSG) {
            this.isPSG = isPSG;
            return this;
        }

        public GameParam isSCC(boolean isSCC) {
            this.isSCC = isSCC;
            return this;
        }

        public GameParam isSCCI(boolean isSCCI) {
            this.isSCCI = isSCCI;
            return this;
        }

        public GameParam isPCM(boolean isPCM) {
            this.isPCM = isPCM;
            return this;
        }

        public GameParam isMSXMUSIC(boolean isMSXMUSIC) {
            this.isMSXMUSIC = isMSXMUSIC;
            return this;
        }

        public GameParam isMSXAUDIO(boolean isMSXAUDIO) {
            this.isMSXAUDIO = isMSXAUDIO;
            return this;
        }

        public GameParam isMoonsound(boolean isMoonsound) {
            this.isMoonsound = isMoonsound;
            return this;
        }

        public GameParam isMIDI(boolean isMIDI) {
            this.isMIDI = isMIDI;
            return this;
        }

        public GameParam genre1(Genre genre1) {
            this.genre1 = genre1;
            return this;
        }

        public GameParam genre2(Genre genre2) {
            this.genre2 = genre2;
            return this;
        }

        public GameParam msxGenID(int msxGenID) {
            this.msxGenID = msxGenID;
            return this;
        }

        public GameParam sha1Code(String sha1Code) {
            this.sha1Code = Utils.resetIfEmpty(sha1Code);
            return this;
        }

        public GameParam size(long size) {
            this.size = size;
            return this;
        }

        public GameParam screenshotSuffix(String screenshotSuffix) {
            this.screenshotSuffix = Utils.resetIfEmpty(screenshotSuffix);
            return this;
        }

        public GameParam tclScript(String tclScript) {
            this.tclScript = Utils.resetIfEmpty(tclScript);
            return this;
        }

        public GameParam tclScriptOverride(boolean tclScriptOverride) {
            this.tclScriptOverride = tclScriptOverride;
            return this;
        }

        public GameParam fddMode(FDDMode fddMode) {
            this.fddMode = fddMode;
            return this;
        }

        public GameParam inputDevice(InputDevice inputDevice) {
            this.inputDevice = inputDevice;
            return this;
        }

        public GameParam connectGFX9000(boolean connectGFX9000) {
            this.connectGFX9000 = connectGFX9000;
            return this;
        }

        public Game build() {
            if (this.name == null && this.romA == null && this.romB == null && this.diskA == null && this.diskB == null && this.tape == null && this.harddisk == null && this.laserdisc == null && this.tclScript == null) {
                throw new IllegalArgumentException("Must set at least one field");
            }
            return new Game(this);
        }
    }
}

