/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.extractor;

import info.msxlaunchers.openmsx.common.ActionDecider;
import info.msxlaunchers.openmsx.common.FileTypeUtils;
import info.msxlaunchers.openmsx.launcher.extractor.ExtractionException;
import info.msxlaunchers.openmsx.launcher.extractor.Extractor;
import info.msxlaunchers.openmsx.launcher.extractor.ExtractorData;
import info.msxlaunchers.openmsx.launcher.extractor.ExtractorExceptionIssue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import jp.gr.java_conf.dangan.util.lha.LhaInputStream;

final class LHAExtractor
implements Extractor {
    private static final int READ_BUFFER_SIZE = 737280;

    LHAExtractor() {
    }

    @Override
    public ExtractorData extract(String fileToExtract, String targetDirectory, boolean extractOnlyMsxImages, ActionDecider actionDecider) throws ExtractionException {
        Path fileToExtractPath = Paths.get(fileToExtract, new String[0]);
        Path directoryToWriteTo = targetDirectory == null ? fileToExtractPath.getParent() : Paths.get(targetDirectory, new String[0]);
        TotalFilesAndMSXImages totalFilesAndMSXImages = this.getTotalFilesAndMSXImages(fileToExtractPath);
        int totalExtractedFiles = this.extratFiles(fileToExtractPath, directoryToWriteTo, extractOnlyMsxImages, actionDecider);
        return new ExtractorData(totalFilesAndMSXImages.totalFiles, totalFilesAndMSXImages.totalMSXImages, totalExtractedFiles);
    }

    /*
     * Exception decompiling
     */
    private int extratFiles(Path fileToExtractPath, Path directoryToWriteTo, boolean extractOnlyMsxImages, ActionDecider actionDecider) throws ExtractionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private TotalFilesAndMSXImages getTotalFilesAndMSXImages(Path fileToExtractPath) throws ExtractionException {
        int totalFiles = 0;
        int totalMSXImages = 0;
        try (FileInputStream is = new FileInputStream(fileToExtractPath.toFile());
             LhaInputStream lis = new LhaInputStream((InputStream)is);){
            LhaHeader header = lis.getNextEntry();
            while (header != null) {
                ++totalFiles;
                File file = new File(header.getPath());
                if (this.isMSXImage(file)) {
                    ++totalMSXImages;
                }
                header = lis.getNextEntry();
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new ExtractionException(ExtractorExceptionIssue.COMPRESSED_FILE_NOT_FOUND);
        }
        catch (IOException ioe) {
            throw new ExtractionException(ExtractorExceptionIssue.IO);
        }
        return new TotalFilesAndMSXImages(totalFiles, totalMSXImages);
    }

    private boolean isMSXImage(File file) {
        return FileTypeUtils.isDisk(file) || FileTypeUtils.isROM(file) || FileTypeUtils.isTape(file);
    }

    private void writeExtractedFile(File fullFilename, LhaInputStream lis, byte[] buffer) throws IOException {
        try (FileOutputStream os = new FileOutputStream(fullFilename);){
            int len;
            while ((len = lis.read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, len);
            }
        }
    }

    private class TotalFilesAndMSXImages {
        private final int totalFiles;
        private final int totalMSXImages;

        TotalFilesAndMSXImages(int totalFiles, int totalMSXImages) {
            this.totalFiles = totalFiles;
            this.totalMSXImages = totalMSXImages;
        }
    }
}

