/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.feed;

import com.google.inject.Inject;
import info.msxlaunchers.openmsx.launcher.data.feed.FeedMessage;
import info.msxlaunchers.openmsx.launcher.feed.FeedReader;
import info.msxlaunchers.openmsx.launcher.feed.FeedService;
import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import info.msxlaunchers.openmsx.launcher.persistence.feed.FeedMessagePersister;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class FeedServiceImpl
implements FeedService {
    private final String[][] sites = new String[][]{{"http://www.msxlaunchers.info/", "feed", "MSX Launchers"}, {"https://www.msx.org/", "feed/news/", "MSX Resource Center"}, {"https://www.msxblog.es/", "feed/", "MSX Blog"}};
    private final int MAX_MESSAGES_LIST_SIZE = 15;
    private final long CHECK_INTERVAL = 1000L;
    private final long TOTAL_RSS_CHECK_PERIOD = 600000L;
    private final long TOTAL_INTERVAL_CHECKS_PER_RSS_CHECK_PERIOD = 600L;
    private Thread service;
    private final FeedReader feedReader;
    private final FeedMessagePersister feedMessagePersister;
    private volatile boolean running;
    private volatile boolean isNewMessages;
    private String previousTopMessage;
    private List<FeedMessage> messages;

    @Inject
    FeedServiceImpl(FeedReader feedReader, FeedMessagePersister feedMessagePersister) {
        this.feedReader = feedReader;
        this.feedMessagePersister = feedMessagePersister;
        this.messages = Collections.emptyList();
        this.previousTopMessage = null;
    }

    @Override
    public void start() {
        if (!this.running) {
            this.running = true;
            this.service = new Thread(this::runService);
            this.service.start();
        }
    }

    @Override
    public void stop() {
        this.running = false;
    }

    @Override
    public boolean isNewMessagesFound() {
        return this.isNewMessages;
    }

    @Override
    public List<FeedMessage> getMessages() throws IOException {
        if (this.isNewMessages) {
            this.isNewMessages = false;
            String firstMessage = this.messages.get(0).toString();
            this.feedMessagePersister.saveMessage(firstMessage);
            this.previousTopMessage = firstMessage;
        }
        return Collections.unmodifiableList(this.messages);
    }

    private void runService() {
        int checksCounter = 0;
        while (this.running) {
            try {
                if (checksCounter == 0) {
                    this.readFeeds();
                    ++checksCounter;
                    continue;
                }
                checksCounter = (long)checksCounter == 600L ? 0 : ++checksCounter;
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException ioe) {
                LauncherLogger.logException(this, ioe);
            }
        }
    }

    private void readFeeds() throws IOException {
        ArrayList<FeedMessage> messagesFromAllSites = new ArrayList<FeedMessage>(100);
        for (int row = 0; row < this.sites.length; ++row) {
            messagesFromAllSites.addAll(this.getFeedMessages(row));
        }
        Collections.sort(messagesFromAllSites, (m1, m2) -> m2.getPubDate().compareTo(m1.getPubDate()));
        this.messages = messagesFromAllSites.subList(0, messagesFromAllSites.size() > 15 ? 15 : messagesFromAllSites.size());
        if (this.previousTopMessage == null && this.feedMessagePersister.isMessagePersisted()) {
            this.previousTopMessage = this.feedMessagePersister.getMessage();
        }
        if (!this.messages.isEmpty() && !this.messages.get(0).toString().equals(this.previousTopMessage)) {
            this.isNewMessages = true;
        }
    }

    private List<FeedMessage> getFeedMessages(int row) {
        try {
            return this.feedReader.read(this.sites[row][0] + this.sites[row][1], this.sites[row][2], this.sites[row][0]);
        }
        catch (IOException ioe) {
            return Collections.emptyList();
        }
    }
}

