/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.importer;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import info.msxlaunchers.openmsx.common.ActionDecider;
import info.msxlaunchers.openmsx.common.FileUtils;
import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.openmsx.launcher.builder.GameBuilder;
import info.msxlaunchers.openmsx.launcher.data.extra.ExtraData;
import info.msxlaunchers.openmsx.launcher.data.game.Game;
import info.msxlaunchers.openmsx.launcher.extra.ExtraDataGetter;
import info.msxlaunchers.openmsx.launcher.importer.DatabaseImporter;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersister;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class BlueMSXLauncherDatabaseImporter
implements DatabaseImporter {
    private final String machine;
    private final GameBuilder gameBuilder;
    private final GamePersister gamePersister;
    private final ExtraDataGetter extraDataGetter;
    private Map<String, ExtraData> extraDataMap;

    @Inject
    BlueMSXLauncherDatabaseImporter(@Assisted String machine, GameBuilder gameBuilder, GamePersister gamePersister, ExtraDataGetter extraDataGetter) {
        this.machine = Objects.requireNonNull(machine);
        this.gameBuilder = Objects.requireNonNull(gameBuilder);
        this.gamePersister = Objects.requireNonNull(gamePersister);
        this.extraDataGetter = Objects.requireNonNull(extraDataGetter);
    }

    @Override
    public Set<String> importDatabases(File[] databases, ActionDecider actionDecider) throws IOException {
        this.extraDataMap = this.extraDataGetter.getExtraData();
        HashSet<String> importedDatabases = new HashSet<String>();
        Set<String> currentOpenMSXLauncherDatabases = this.gamePersister.getDatabases();
        for (File database : databases) {
            String databaseName = FileUtils.getFileNameWithoutExtension(database);
            if (currentOpenMSXLauncherDatabases.contains(databaseName)) {
                if (!actionDecider.isYesAll() && !actionDecider.isNoAll()) {
                    actionDecider.promptForAction(databaseName);
                }
                if (actionDecider.isYes() || actionDecider.isYesAll()) {
                    try {
                        this.gamePersister.deleteDatabase(databaseName);
                    }
                    catch (GamePersistenceException gamePersistenceException) {
                        // empty catch block
                    }
                    this.migrateDatabaseToOpenMSX(importedDatabases, database, databaseName);
                    continue;
                }
                if (actionDecider.isNo() || actionDecider.isNoAll()) continue;
                if (actionDecider.isCancel()) break;
                throw new RuntimeException("At least one action must be set");
            }
            this.migrateDatabaseToOpenMSX(importedDatabases, database, databaseName);
        }
        return Collections.unmodifiableSet(importedDatabases);
    }

    private void migrateDatabaseToOpenMSX(Set<String> importedDatabases, File database, String databaseName) throws IOException {
        boolean srcDatabaseFound;
        HashSet<Game> games = new HashSet<Game>();
        String importedDatabaseName = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(database), "UTF-8"));){
            String line;
            srcDatabaseFound = true;
            while ((line = reader.readLine()) != null) {
                String harddisk;
                String tape;
                String diskB;
                String diskA;
                String extensionRom;
                String romB;
                String romA;
                String info;
                String[] parts;
                String name;
                Game game;
                if (Utils.isEmpty(line) || (game = this.gameBuilder.createGameObjectForImportedData(name = this.getElementFromDatabaseRowArray(parts = line.split("\\|"), 0), info = this.getElementFromDatabaseRowArray(parts, 6), this.machine, romA = this.getElementFromDatabaseRowArray(parts, 1), romB = this.getElementFromDatabaseRowArray(parts, 2), extensionRom = this.getExtensionRom(this.getElementFromDatabaseRowArray(parts, 13)), diskA = this.getElementFromDatabaseRowArray(parts, 3), diskB = this.getElementFromDatabaseRowArray(parts, 4), tape = this.getElementFromDatabaseRowArray(parts, 11), harddisk = this.getElementFromDatabaseRowArray(parts, 15), this.extraDataMap)) == null) continue;
                games.add(game);
            }
        }
        catch (FileNotFoundException fnfe) {
            srcDatabaseFound = false;
        }
        if (srcDatabaseFound) {
            try {
                this.gamePersister.createDatabase(databaseName);
            }
            catch (GamePersistenceException gamePersistenceException) {
                // empty catch block
            }
            try {
                this.gamePersister.saveGames(games, databaseName);
                importedDatabaseName = databaseName;
            }
            catch (GamePersistenceException gamePersistenceException) {
                // empty catch block
            }
        }
        if (importedDatabaseName != null) {
            importedDatabases.add(importedDatabaseName);
        }
    }

    private String getElementFromDatabaseRowArray(String[] array, int index) {
        String element = null;
        if (index < array.length) {
            element = Utils.resetIfEmpty(array[index]);
        }
        return element;
    }

    private String getExtensionRom(String extensionRom) {
        String openMSXExtensionRom = null;
        if (extensionRom != null) {
            switch (extensionRom) {
                case "scc": 
                case "scc+": 
                case "fmpac": {
                    openMSXExtensionRom = extensionRom;
                    break;
                }
                case "sunriseide": {
                    openMSXExtensionRom = "ide";
                    break;
                }
                case "fmpak": {
                    openMSXExtensionRom = "pac";
                    break;
                }
            }
        }
        return openMSXExtensionRom;
    }
}

