/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.patch;

import info.msxlaunchers.openmsx.common.HashUtils;
import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import info.msxlaunchers.openmsx.launcher.patch.AbstractPatcher;
import info.msxlaunchers.openmsx.launcher.patch.PatchException;
import info.msxlaunchers.openmsx.launcher.patch.PatchExceptionIssue;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;

final class UPSPatcher
extends AbstractPatcher {
    private final byte[] PATCH_HEADER = "UPS1".getBytes();
    private final String tempOutputFile = "tempOutputFile.tmp";
    private final int CRC_LENGTH = 4;
    private final int CRC_CHECKS_LENGTH = 12;
    private final int RANDOM_ACCESS_FILE_BUFFER_SIZE = 4096;

    UPSPatcher() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void performValidation(Path fileToPatch, Path patchFile, boolean skipChecksumValidation, String checksum) throws PatchException {
        if (!skipChecksumValidation) {
            void var6_12;
            String sourceChecksumFromPatch;
            try (BufferedRandomAccessFile patchStream = new BufferedRandomAccessFile(patchFile.toFile(), "r");){
                long patchDataSize = this.getPatchDataSize(patchFile);
                patchStream.seek(patchDataSize);
                sourceChecksumFromPatch = this.getCRCFromPatch(patchStream);
                patchStream.seek(patchDataSize + 8L);
                String patchChecksumFromPatch = this.getCRCFromPatch(patchStream);
            }
            catch (IOException ioe) {
                LauncherLogger.logException(this, ioe);
                throw new PatchException(PatchExceptionIssue.IO);
            }
            String sourceChecksum = HashUtils.getCRC32Code(fileToPatch.toFile());
            if (!sourceChecksum.equalsIgnoreCase(sourceChecksumFromPatch)) {
                throw new PatchException(PatchExceptionIssue.SOURCE_FILE_CHECKSUM_NOT_MATCH);
            }
            String patchChecksum = this.getPatchFileCRC(patchFile);
            if (!patchChecksum.equalsIgnoreCase((String)var6_12)) {
                throw new PatchException(PatchExceptionIssue.INVALID_PATCH_FILE);
            }
        }
    }

    @Override
    protected void patchFileData(Path fileToPatch, Path patchFile, Path targetFile, boolean skipChecksumValidation) throws PatchException {
        Path temporaryOutputFile = this.createTempOutputfile(fileToPatch);
        try (PositionedBufferedInputStream patchStream = new PositionedBufferedInputStream(new FileInputStream(patchFile.toFile()));
             BufferedRandomAccessFile resultStream = new BufferedRandomAccessFile(temporaryOutputFile.toFile(), "rw");){
            this.validatePatchHeader(patchStream);
            long sourceFileSize = this.getValueFromPatch(patchStream);
            long targetFileSize = this.getValueFromPatch(patchStream);
            this.enlargeTempOutputfileIfNecessary(temporaryOutputFile, sourceFileSize, targetFileSize);
            this.patch(patchFile, patchStream, resultStream);
            this.shrinkTempOutputfileIfNecessary(temporaryOutputFile, sourceFileSize, targetFileSize);
            this.validateTargetFileChecksum(patchStream, temporaryOutputFile, skipChecksumValidation);
            this.moveToAppropriateTarget(temporaryOutputFile, fileToPatch, targetFile);
        }
        catch (IOException ioe) {
            LauncherLogger.logException(this, ioe);
            throw new PatchException(PatchExceptionIssue.IO);
        }
        finally {
            this.cleanupTemporaryOutputFile(temporaryOutputFile);
        }
    }

    private String getCRCFromPatch(InputStream in) throws PatchException {
        byte[] crcBytes = new byte[4];
        try {
            in.read(crcBytes);
            return Integer.toHexString(ByteBuffer.wrap(crcBytes).order(ByteOrder.LITTLE_ENDIAN).getInt());
        }
        catch (IOException ioe) {
            LauncherLogger.logException(this, ioe);
            throw new PatchException(PatchExceptionIssue.IO);
        }
    }

    private String getCRCFromPatch(RandomAccessFile in) throws PatchException {
        byte[] crcBytes = new byte[4];
        try {
            in.read(crcBytes);
            return Integer.toHexString(ByteBuffer.wrap(crcBytes).order(ByteOrder.LITTLE_ENDIAN).getInt());
        }
        catch (IOException ioe) {
            LauncherLogger.logException(this, ioe);
            throw new PatchException(PatchExceptionIssue.IO);
        }
    }

    private void patch(Path patchFile, PositionedBufferedInputStream patchStream, RandomAccessFile resultStream) throws PatchException {
        long patchDataSize = this.getPatchDataSize(patchFile);
        long offset = 0L;
        while (patchStream.getPosition() != patchDataSize) {
            offset += this.getValueFromPatch(patchStream);
            ArrayList<Integer> xoredData = new ArrayList<Integer>(4096);
            try {
                long writeOffset = offset;
                resultStream.seek(offset);
                int b = patchStream.read();
                while (b != 0) {
                    xoredData.add(resultStream.read() ^ b);
                    ++offset;
                    b = patchStream.read();
                }
                resultStream.seek(writeOffset);
                resultStream.write(this.getDataByteArray(xoredData));
                ++offset;
            }
            catch (IOException ioe) {
                LauncherLogger.logException(this, ioe);
                throw new PatchException(PatchExceptionIssue.IO);
            }
        }
    }

    private long getPatchDataSize(Path patchFile) throws PatchException {
        try {
            long size = Files.size(patchFile) - 12L;
            if (size <= 0L) {
                throw new PatchException(PatchExceptionIssue.INVALID_PATCH_FILE);
            }
            return size;
        }
        catch (IOException ioe) {
            LauncherLogger.logException(this, ioe);
            throw new PatchException(PatchExceptionIssue.IO);
        }
    }

    private byte[] getDataByteArray(List<Integer> data) {
        int length = data.size();
        byte[] byteArray = new byte[length];
        for (int index = 0; index < length; ++index) {
            byteArray[index] = data.get(index).byteValue();
        }
        return byteArray;
    }

    private Path createTempOutputfile(Path source) throws PatchException {
        try {
            Path tempFile = Files.createTempFile("tempOutputFile.tmp", null, new FileAttribute[0]);
            Files.copy(source, tempFile, StandardCopyOption.REPLACE_EXISTING);
            return tempFile;
        }
        catch (IOException ioe) {
            LauncherLogger.logException(this, ioe);
            throw new PatchException(PatchExceptionIssue.IO);
        }
    }

    private void enlargeTempOutputfileIfNecessary(Path temporaryOutputFile, long sourceFileSize, long targetFileSize) throws PatchException {
        if (targetFileSize > sourceFileSize) {
            long totalToAdd = targetFileSize - sourceFileSize;
            long numberOfChunks = totalToAdd / 0x200000L;
            byte[] bytesToWrite = new byte[0x200000];
            try {
                int index = 0;
                while ((long)index < numberOfChunks) {
                    Files.write(temporaryOutputFile, bytesToWrite, StandardOpenOption.APPEND);
                    ++index;
                }
                int modulo = (int)(totalToAdd % 0x200000L);
                Files.write(temporaryOutputFile, new byte[modulo], StandardOpenOption.APPEND);
            }
            catch (IOException ioe) {
                LauncherLogger.logException(this, ioe);
                throw new PatchException(PatchExceptionIssue.IO);
            }
        }
    }

    private void shrinkTempOutputfileIfNecessary(Path temporaryOutputFile, long sourceFileSize, long targetFileSize) throws PatchException {
        if (targetFileSize < sourceFileSize) {
            try (FileOutputStream os = new FileOutputStream(temporaryOutputFile.toFile(), true);
                 FileChannel outChan = os.getChannel();){
                outChan.truncate(targetFileSize);
            }
            catch (IOException ioe) {
                LauncherLogger.logException(this, ioe);
                throw new PatchException(PatchExceptionIssue.IO);
            }
        }
    }

    private void validatePatchHeader(InputStream inputStream) throws PatchException {
        byte[] header = new byte[this.PATCH_HEADER.length];
        try {
            inputStream.read(header, 0, this.PATCH_HEADER.length);
            if (!this.isByteSequenceEqualToString(header, 0, this.PATCH_HEADER)) {
                throw new PatchException(PatchExceptionIssue.INVALID_PATCH_FILE);
            }
        }
        catch (IOException ioe) {
            LauncherLogger.logException(this, ioe);
            throw new PatchException(PatchExceptionIssue.IO);
        }
    }

    private long getValueFromPatch(InputStream in) throws PatchException {
        try {
            int b = in.read();
            long value = b & 0x7F;
            int index = 1;
            while ((b & 0x80) == 0) {
                b = in.read();
                value += (long)((b & 0x7F) + 1 << 7 * index);
                ++index;
            }
            return value;
        }
        catch (IOException ioe) {
            throw new PatchException(PatchExceptionIssue.INVALID_PATCH_FILE);
        }
    }

    private void validateTargetFileChecksum(InputStream patchStream, Path outputFile, boolean skipChecksumValidation) throws PatchException {
        if (!skipChecksumValidation) {
            this.getCRCFromPatch(patchStream);
            String targetChecksumFromPatch = this.getCRCFromPatch(patchStream);
            String targetChecksum = HashUtils.getCRC32Code(outputFile.toFile());
            if (!targetChecksum.equalsIgnoreCase(targetChecksumFromPatch)) {
                throw new PatchException(PatchExceptionIssue.INVALID_PATCH_FILE);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getPatchFileCRC(Path patchFile) throws PatchException {
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(patchFile.toFile()), 0x200000);){
            long patchDataSizeForCRCChecksum = Files.size(patchFile) - 4L;
            CRC32 crc = new CRC32();
            for (long index = 0L; index < patchDataSizeForCRCChecksum; ++index) {
                crc.update(((InputStream)inputStream).read());
            }
            String string = Long.toHexString(crc.getValue());
            return string;
        }
        catch (IOException ioe) {
            LauncherLogger.logException(this, ioe);
            throw new PatchException(PatchExceptionIssue.IO);
        }
    }

    private void moveToAppropriateTarget(Path temporaryFile, Path fileToPatch, Path targetFile) throws PatchException {
        Path finalPatchedFile = targetFile == null ? fileToPatch : targetFile;
        try {
            Files.copy(temporaryFile, finalPatchedFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ioe) {
            LauncherLogger.logException(this, ioe);
            throw new PatchException(PatchExceptionIssue.IO);
        }
    }

    private void cleanupTemporaryOutputFile(Path temporaryOutputFile) {
        try {
            Files.deleteIfExists(temporaryOutputFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class BufferedRandomAccessFile
    extends RandomAccessFile {
        private final int bufferSize;
        private byte[] buffer;
        private int bufferIndex;

        BufferedRandomAccessFile(File file, String mode) throws FileNotFoundException {
            super(file, mode);
            this.bufferSize = 4096;
            this.bufferIndex = 0;
        }

        @Override
        public int read() throws IOException {
            if (this.bufferIndex == 0) {
                this.buffer = new byte[this.bufferSize];
                this.read(this.buffer);
            }
            byte data = this.buffer[this.bufferIndex++];
            if (this.bufferIndex == this.bufferSize) {
                this.bufferIndex = 0;
            }
            return data;
        }

        @Override
        public void seek(long position) throws IOException {
            super.seek(position);
            this.bufferIndex = 0;
        }
    }

    private class PositionedBufferedInputStream
    extends BufferedInputStream {
        long position;

        PositionedBufferedInputStream(InputStream in) {
            super(in, 0x200000);
            this.position = 0L;
        }

        @Override
        public int read() throws IOException {
            int b = super.read();
            if (b > -1) {
                ++this.position;
            }
            return b;
        }

        @Override
        public int read(byte[] data, int off, int len) throws IOException {
            this.position = off + len;
            return super.read(data, off, len);
        }

        long getPosition() {
            return this.position;
        }
    }
}

