/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence.favorite;

import info.msxlaunchers.openmsx.launcher.data.game.DatabaseItem;
import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import info.msxlaunchers.openmsx.launcher.persistence.DefaultDatabaseResponse;
import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.TransactionalDatabaseOperation;
import info.msxlaunchers.openmsx.launcher.persistence.favorite.FavoritePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.favorite.FavoritePersistenceExceptionIssue;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

final class DeleteFavoriteAction
extends TransactionalDatabaseOperation<Boolean> {
    private static final String DELETE_FAVORITE_STATEMENT = "DELETE FROM favorite where IDGAME = (SELECT game.ID FROM game join database on game.IDDB=database.ID and game.name=? and database.name=?)";
    private final DatabaseItem favorite;

    DeleteFavoriteAction(DatabaseItem favorite) {
        this.favorite = favorite;
    }

    public DefaultDatabaseResponse executeTransactionalOperation(Connection connection) throws LauncherPersistenceException {
        try (PreparedStatement statement = connection.prepareStatement(DELETE_FAVORITE_STATEMENT);){
            statement.setString(1, this.favorite.getGameName());
            statement.setString(2, this.favorite.getDatabase());
            statement.executeUpdate();
        }
        catch (SQLException se) {
            LauncherLogger.logException(this, se);
            this.throwEncapsulatingException(new FavoritePersistenceException(FavoritePersistenceExceptionIssue.IO));
        }
        return new DefaultDatabaseResponse();
    }
}

