/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence.favorite;

import info.msxlaunchers.openmsx.launcher.data.game.DatabaseItem;
import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import info.msxlaunchers.openmsx.launcher.persistence.DatabaseResponse;
import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.NonTransactionalDatabaseOperation;
import info.msxlaunchers.openmsx.launcher.persistence.favorite.GetFavoritesResponse;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

final class GetFavoritesAction
extends NonTransactionalDatabaseOperation<Set<DatabaseItem>> {
    private static final String GET_ALL_FAVORITES_STATEMENT = "SELECT game.name AS gameName, database.name AS database FROM database JOIN game ON database.id=game.IDDB join favorite ON favorite.IDGAME=game.ID";

    GetFavoritesAction() {
    }

    @Override
    public DatabaseResponse<Set<DatabaseItem>> executeNonTransactionalOperation(Connection connection) throws LauncherPersistenceException {
        HashSet<DatabaseItem> favorites = new HashSet<DatabaseItem>();
        try (PreparedStatement statement = connection.prepareStatement(GET_ALL_FAVORITES_STATEMENT);
             ResultSet result = statement.executeQuery();){
            while (result.next()) {
                favorites.add(new DatabaseItem(result.getString("gameName"), result.getString("database")));
            }
        }
        catch (SQLException se) {
            LauncherLogger.logException(this, se);
        }
        return new GetFavoritesResponse(Collections.unmodifiableSet(favorites));
    }
}

