/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence.filter;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import info.msxlaunchers.openmsx.launcher.data.filter.Filter;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterFactory;
import info.msxlaunchers.openmsx.launcher.data.filter.ParameterField;
import info.msxlaunchers.openmsx.launcher.data.filter.Value1Field;
import info.msxlaunchers.openmsx.launcher.data.filter.Value2Field;
import info.msxlaunchers.openmsx.launcher.persistence.filter.FilterPersister;
import info.msxlaunchers.openmsx.launcher.persistence.filter.FilterSetAlreadyExistsException;
import info.msxlaunchers.openmsx.launcher.persistence.filter.FilterSetNotFoundException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;

@Singleton
final class JSONFilterPersister
implements FilterPersister {
    private final File filtersFile;
    private static final String FILTERS_DIRECTORY = "filters";
    private static final String FILTERS_FILENAME = "filters.json";
    private static final String JSON_NAME_FIELD = "name";
    private static final String JSON_FILTERS_FIELD = "filters";
    private static final String JSON_TYPE_FIELD = "type";
    private static final String JSON_VALUE1_FIELD = "value1";
    private static final String JSON_VALUE2_FIELD = "value2";
    private static final String JSON_FILTER_PRAMETER_FIELD = "filterParameter";
    private static final String UNUSED_NUMERIC_VALUE = "0";
    private Map<String, Set<Filter>> filtersMap = null;

    @Inject
    JSONFilterPersister(@Named(value="UserDataDirectory") String userDataDirectory) {
        File filtersDirectory = new File(userDataDirectory, "filters");
        if (!filtersDirectory.exists()) {
            filtersDirectory.mkdir();
        }
        this.filtersFile = new File(filtersDirectory, FILTERS_FILENAME);
    }

    @Override
    public void saveFilter(String name, Set<Filter> filters) throws FilterSetAlreadyExistsException, IOException {
        this.initializeFiltersMapIfNecessary();
        if (this.filtersMap.containsKey(name)) {
            throw new FilterSetAlreadyExistsException(name);
        }
        this.filtersMap.put(name, filters);
        this.flushFiltersMapToDisk();
    }

    @Override
    public void deleteFilter(String name) throws IOException {
        this.initializeFiltersMapIfNecessary();
        this.filtersMap.remove(name);
        this.flushFiltersMapToDisk();
    }

    @Override
    public Set<Filter> getFilter(String name) throws FilterSetNotFoundException {
        this.initializeFiltersMapIfNecessary();
        if (!this.filtersMap.containsKey(name)) {
            throw new FilterSetNotFoundException(name);
        }
        return Collections.unmodifiableSet(this.filtersMap.get(name));
    }

    @Override
    public Set<String> getFilterNames() {
        this.initializeFiltersMapIfNecessary();
        TreeSet<String> sortedFilterNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        sortedFilterNames.addAll(this.filtersMap.keySet());
        return Collections.unmodifiableSet(sortedFilterNames);
    }

    private void initializeFiltersMapIfNecessary() {
        if (this.filtersMap == null) {
            this.filtersMap = new HashMap<String, Set<Filter>>();
            try (FileInputStream stream = new FileInputStream(this.filtersFile);){
                this.parseJASONFile(stream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void parseJASONFile(InputStream stream) {
        JSONArray jsonArray = (JSONArray)JSONValue.parse((InputStream)stream);
        for (Object array : jsonArray) {
            JSONObject jsonObj = (JSONObject)array;
            String filterName = jsonObj.get((Object)JSON_NAME_FIELD).toString();
            JSONArray jsonFiltersArray = (JSONArray)jsonObj.get((Object)"filters");
            HashSet<Filter> filtersSet = new HashSet<Filter>();
            for (Object jsonFilters : jsonFiltersArray) {
                JSONObject jsonFiltersObj = (JSONObject)jsonFilters;
                Filter filter = FilterFactory.createFilter(this.getJSONFieldValue(jsonFiltersObj.get((Object)JSON_TYPE_FIELD)), this.getJSONFieldValue(jsonFiltersObj.get((Object)JSON_VALUE1_FIELD)), this.getJSONFieldValue(jsonFiltersObj.get((Object)JSON_VALUE2_FIELD)), this.getJSONFieldValue(jsonFiltersObj.get((Object)JSON_FILTER_PRAMETER_FIELD)));
                filtersSet.add(filter);
            }
            this.filtersMap.put(filterName, filtersSet);
        }
    }

    private String getJSONFieldValue(Object field) {
        String value = field == null ? null : field.toString();
        return value;
    }

    private void flushFiltersMapToDisk() throws IOException {
        JSONArray jsonArray = new JSONArray();
        for (String name : this.filtersMap.keySet()) {
            JSONObject namedJsonObj = new JSONObject();
            namedJsonObj.put((Object)JSON_NAME_FIELD, (Object)name);
            JSONArray jsonFiltersArray = new JSONArray();
            Set<Filter> filters = this.filtersMap.get(name);
            for (Filter filter : filters) {
                JSONObject filtersJsonObj = new JSONObject();
                filtersJsonObj.put((Object)JSON_TYPE_FIELD, (Object)FilterFactory.getFilterType(filter));
                this.setFiltersJSONObject(filtersJsonObj, JSON_VALUE1_FIELD, FilterFactory.getAnnotatedFieldValue(filter, Value1Field.class));
                this.setFiltersJSONObject(filtersJsonObj, JSON_VALUE2_FIELD, FilterFactory.getAnnotatedFieldValue(filter, Value2Field.class));
                this.setFiltersJSONObject(filtersJsonObj, JSON_FILTER_PRAMETER_FIELD, FilterFactory.getAnnotatedFieldValue(filter, ParameterField.class));
                jsonFiltersArray.add((Object)filtersJsonObj);
            }
            namedJsonObj.put((Object)"filters", (Object)jsonFiltersArray);
            jsonArray.add((Object)namedJsonObj);
        }
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.filtersFile), "UTF-8"));){
            bufferedWriter.write(jsonArray.toJSONString());
        }
    }

    private void setFiltersJSONObject(JSONObject jsonObject, String key, String value) {
        if (value != null && !value.equals(UNUSED_NUMERIC_VALUE)) {
            jsonObject.put((Object)key, (Object)value);
        }
    }
}

