/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence.game;

import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import info.msxlaunchers.openmsx.launcher.persistence.DefaultDatabaseResponse;
import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.TransactionalDatabaseOperation;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceExceptionIssue;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

final class DeleteDatabaseAction
extends TransactionalDatabaseOperation<Boolean> {
    private static final String DELETE_DATABASE_STATEMENT = "DELETE FROM database WHERE name=?";
    private final String database;

    DeleteDatabaseAction(String database) {
        this.database = database;
    }

    public DefaultDatabaseResponse executeTransactionalOperation(Connection connection) throws LauncherPersistenceException {
        try (PreparedStatement statement = connection.prepareStatement(DELETE_DATABASE_STATEMENT);){
            statement.setString(1, this.database);
            int deleteCount = statement.executeUpdate();
            if (deleteCount == 0) {
                this.throwEncapsulatingException(new GamePersistenceException(GamePersistenceExceptionIssue.DATABASE_NOT_FOUND, this.database));
            }
        }
        catch (SQLException se) {
            LauncherLogger.logException(this, se);
            this.throwEncapsulatingException(new GamePersistenceException(GamePersistenceExceptionIssue.IO));
        }
        return new DefaultDatabaseResponse();
    }
}

