/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence.game;

import info.msxlaunchers.openmsx.launcher.data.backup.DatabaseBackup;
import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import info.msxlaunchers.openmsx.launcher.persistence.DefaultDatabaseResponse;
import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.TransactionalDatabaseOperation;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceExceptionIssue;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

final class DeleteDatabaseBackupAction
extends TransactionalDatabaseOperation<Boolean> {
    private static final String DELETE_DATABASE_BACKUP_STATEMENT = "DELETE FROM database_backup where time=? and IDDB=?";
    private final DatabaseBackup backup;

    DeleteDatabaseBackupAction(DatabaseBackup backup) {
        this.backup = backup;
    }

    public DefaultDatabaseResponse executeTransactionalOperation(Connection connection) throws LauncherPersistenceException {
        long databaseId = this.getDatabaseId(connection, this.backup.getDatabase());
        try (PreparedStatement deleteDatabaseBackupStatement = connection.prepareStatement(DELETE_DATABASE_BACKUP_STATEMENT);){
            deleteDatabaseBackupStatement.setTimestamp(1, this.backup.getTimestamp());
            deleteDatabaseBackupStatement.setLong(2, databaseId);
            deleteDatabaseBackupStatement.executeUpdate();
        }
        catch (SQLException se) {
            LauncherLogger.logException(this, se);
            this.throwEncapsulatingException(new GamePersistenceException(GamePersistenceExceptionIssue.IO));
        }
        return new DefaultDatabaseResponse();
    }
}

