/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence.game;

import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import info.msxlaunchers.openmsx.launcher.persistence.DatabaseResponse;
import info.msxlaunchers.openmsx.launcher.persistence.NonTransactionalDatabaseOperation;
import info.msxlaunchers.openmsx.launcher.persistence.game.GetDatabasesResponse;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;

final class GetDatabasesAction
extends NonTransactionalDatabaseOperation<Set<String>> {
    private static final String GET_ALL_DATABASES_STATEMENT = "SELECT * FROM database";

    GetDatabasesAction() {
    }

    @Override
    public DatabaseResponse<Set<String>> executeNonTransactionalOperation(Connection connection) {
        HashSet<String> databases = new HashSet<String>();
        try (Statement statement = connection.createStatement();
             ResultSet result = statement.executeQuery(GET_ALL_DATABASES_STATEMENT);){
            while (result.next()) {
                databases.add(result.getString("name"));
            }
        }
        catch (SQLException se) {
            LauncherLogger.logException(this, se);
        }
        return new GetDatabasesResponse(databases);
    }
}

