/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence.game;

import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import info.msxlaunchers.openmsx.launcher.persistence.DefaultDatabaseResponse;
import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.TransactionalDatabaseOperation;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceExceptionIssue;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

final class RenameDatabaseAction
extends TransactionalDatabaseOperation<Boolean> {
    private static final String RENAME_DATABASE_STATEMENT = "UPDATE database SET name=? WHERE name=?";
    private final String oldDatabase;
    private final String newDatabase;

    RenameDatabaseAction(String oldDatabase, String newDatabase) {
        this.oldDatabase = oldDatabase;
        this.newDatabase = newDatabase;
    }

    public DefaultDatabaseResponse executeTransactionalOperation(Connection connection) throws LauncherPersistenceException {
        try (PreparedStatement statement = connection.prepareStatement(RENAME_DATABASE_STATEMENT);){
            statement.setString(1, this.newDatabase);
            statement.setString(2, this.oldDatabase);
            int updateCount = statement.executeUpdate();
            if (updateCount != 1) {
                this.throwEncapsulatingException(new GamePersistenceException(GamePersistenceExceptionIssue.DATABASE_NOT_FOUND, this.oldDatabase));
            }
        }
        catch (SQLException se) {
            if (this.isDuplicateError(se)) {
                this.throwEncapsulatingException(new GamePersistenceException(GamePersistenceExceptionIssue.DATABASE_ALREADY_EXISTS, this.newDatabase));
            }
            LauncherLogger.logException(this, se);
            this.throwEncapsulatingException(new GamePersistenceException(GamePersistenceExceptionIssue.IO));
        }
        return new DefaultDatabaseResponse();
    }
}

