/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence.game;

import info.msxlaunchers.openmsx.launcher.data.backup.DatabaseBackup;
import info.msxlaunchers.openmsx.launcher.persistence.DefaultDatabaseResponse;
import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.TransactionalDatabaseOperation;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceExceptionIssue;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

final class RestoreDatabaseBackupAction
extends TransactionalDatabaseOperation<Boolean> {
    private static final String DELETE_CURRENT_GAMES_STATEMENT = "DELETE FROM game where IDDB=?";
    private static final String GET_BACKUP_ID_STATEMENT = "SELECT ID FROM database_backup where IDDB=? and time=?";
    private static final String RESTORE_GAMES_STATEMENT = "INSERT INTO game (name, info, machine, romA, extension_rom, romB, diskA, diskB, tape, harddisk, laserdisc, tcl_script, msx, msx2, msx2plus, turbo_r, psg, scc, scc_i, pcm, msx_music, msx_audio, moonsound, midi, genre1, genre2, msx_genid, screenshot_suffix, sha1, size, IDDB, fdd_mode, tcl_script_override, input_device, connect_gfx9000) SELECT name, info, machine, romA, extension_rom, romB, diskA, diskB, tape, harddisk, laserdisc, tcl_script, msx, msx2, msx2plus, turbo_r, psg, scc, scc_i, pcm, msx_music, msx_audio, moonsound, midi,genre1, genre2, msx_genid, screenshot_suffix, sha1, size, ?, fdd_mode, tcl_script_override, input_device, connect_gfx9000 FROM game_backup where IDDB=?";
    private static final String DELETE_BACKUP_STATEMENT = "DELETE FROM database_backup where ID=?";
    private final DatabaseBackup backup;

    RestoreDatabaseBackupAction(DatabaseBackup backup) {
        this.backup = backup;
    }

    public DefaultDatabaseResponse executeTransactionalOperation(Connection connection) throws LauncherPersistenceException {
        long databaseId = this.getDatabaseId(connection, this.backup.getDatabase());
        try (PreparedStatement deleteCurrentGamesStatement = connection.prepareStatement(DELETE_CURRENT_GAMES_STATEMENT);
             PreparedStatement getBackupIDStatement = connection.prepareStatement(GET_BACKUP_ID_STATEMENT);
             PreparedStatement restoreGamesStatement = connection.prepareStatement(RESTORE_GAMES_STATEMENT);
             PreparedStatement deleteBackupStatement = connection.prepareStatement(DELETE_BACKUP_STATEMENT);){
            deleteCurrentGamesStatement.setLong(1, databaseId);
            deleteCurrentGamesStatement.executeUpdate();
            getBackupIDStatement.setLong(1, databaseId);
            getBackupIDStatement.setTimestamp(2, this.backup.getTimestamp());
            long databaseBackupId = 0L;
            try (ResultSet result = getBackupIDStatement.executeQuery();){
                result.next();
                databaseBackupId = result.getLong("ID");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (databaseBackupId == 0L) {
                this.throwEncapsulatingException(new GamePersistenceException(GamePersistenceExceptionIssue.BACKUP_NOT_FOUND, this.backup.getTimestamp().toString()));
            }
            restoreGamesStatement.setLong(1, databaseId);
            restoreGamesStatement.setLong(2, databaseBackupId);
            restoreGamesStatement.executeUpdate();
            deleteBackupStatement.setLong(1, databaseBackupId);
            deleteBackupStatement.executeUpdate();
        }
        catch (SQLException se) {
            this.throwEncapsulatingException(new GamePersistenceException(GamePersistenceExceptionIssue.IO));
        }
        return new DefaultDatabaseResponse();
    }
}

