/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence.search;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.openmsx.launcher.data.game.DatabaseItem;
import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.search.GameFinder;
import info.msxlaunchers.openmsx.launcher.persistence.search.GameFinderAction;
import java.util.Collections;
import java.util.Set;

final class EmbeddedDatabaseGameFinder
implements GameFinder {
    private final String databaseFullPath;

    @Inject
    EmbeddedDatabaseGameFinder(@Named(value="EmbeddedDatabaseFullPath") String databaseFullPath) {
        this.databaseFullPath = databaseFullPath;
    }

    @Override
    public Set<DatabaseItem> find(String string, int maximumMatches) {
        try {
            if (!Utils.isEmpty(string)) {
                return (Set)new GameFinderAction(string, maximumMatches).execute(this.databaseFullPath).getResult();
            }
        }
        catch (LauncherPersistenceException launcherPersistenceException) {
            // empty catch block
        }
        return Collections.emptySet();
    }
}

